/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.command.ChunkCommand;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CommandMek {
    private static final Map<UUID, Stack<BlockPos>> tpStack = new Object2ObjectOpenHashMap();

    private CommandMek() {
    }

    public static LiteralArgumentBuilder<CommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"mek").requires(cs -> cs.func_197022_f() instanceof ServerPlayerEntity)).then(DebugCommand.register())).then(TestRulesCommand.register())).then(TpCommand.register())).then(TppopCommand.register())).then(ChunkCommand.register())).then(BuildCommand.COMMAND)).then(RadiationCommand.register());
    }

    private static void teleport(Entity player, double x, double y, double z) {
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity mp = (ServerPlayerEntity)player;
            mp.field_71135_a.func_147364_a(x, y, z, mp.field_70177_z, mp.field_70125_A);
        } else {
            ClientPlayerEntity sp = (ClientPlayerEntity)player;
            sp.func_70012_b(x, y, z, sp.field_70177_z, sp.field_70125_A);
        }
    }

    private static class RadiationCommand {
        private RadiationCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"radiation").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"magnitude", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)10000.0)).executes(ctx -> {
                try {
                    CommandSource source = (CommandSource)ctx.getSource();
                    Coord4D location = new Coord4D(source.func_197036_d().field_72450_a, source.func_197036_d().field_72448_b, source.func_197036_d().field_72449_c, (RegistryKey<World>)source.func_197023_e().func_234923_W_());
                    double magnitude = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude");
                    Mekanism.radiationManager.radiate(location, magnitude);
                    source.func_197030_a((ITextComponent)MekanismLang.COMMAND_RADIATION_ADD.translate(location), true);
                }
                catch (Exception e) {
                    Mekanism.logger.error("Failed to radiate", (Throwable)e);
                }
                return 0;
            })))).then(Commands.func_197057_a((String)"get").executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                Coord4D location = new Coord4D(source.func_197036_d().field_72450_a, source.func_197036_d().field_72448_b, source.func_197036_d().field_72449_c, (RegistryKey<World>)source.func_197023_e().func_234923_W_());
                double radiation = Mekanism.radiationManager.getRadiationLevel(location);
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_RADIATION_GET.translate(radiation), true);
                return 0;
            }))).then(Commands.func_197057_a((String)"heal").executes(ctx -> {
                if (((CommandSource)ctx.getSource()).func_197022_f() instanceof ServerPlayerEntity) {
                    ServerPlayerEntity player = (ServerPlayerEntity)((CommandSource)ctx.getSource()).func_197022_f();
                    player.getCapability(Capabilities.RADIATION_ENTITY_CAPABILITY).ifPresent(c -> c.set(0.0));
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)MekanismLang.COMMAND_RADIATION_CLEAR.translate(new Object[0]), true);
                }
                return 0;
            }))).then(Commands.func_197057_a((String)"removeAll").executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                Mekanism.radiationManager.clearSources();
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_RADIATION_REMOVE_ALL.translate(new Object[0]), true);
                return 0;
            }));
        }
    }

    private static class TppopCommand {
        private TppopCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpop").requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                UUID player = source.func_197022_f().func_110124_au();
                Stack playerLocations = tpStack.getOrDefault(player, new Stack());
                if (playerLocations.isEmpty()) {
                    source.func_197030_a((ITextComponent)MekanismLang.COMMAND_TPOP_EMPTY.translate(new Object[0]), true);
                } else {
                    BlockPos lastPos = (BlockPos)playerLocations.pop();
                    tpStack.put(player, playerLocations);
                    CommandMek.teleport(source.func_197022_f(), lastPos.func_177958_n(), lastPos.func_177956_o(), lastPos.func_177952_p());
                    source.func_197030_a((ITextComponent)MekanismLang.COMMAND_TPOP.translate(lastPos.func_177958_n(), lastPos.func_177956_o(), lastPos.func_177952_p(), playerLocations.size()), true);
                }
                return 0;
            });
        }
    }

    private static class TpCommand {
        private TpCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"tp").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                Entity entity = source.func_197022_f();
                if (entity != null) {
                    UUID player = entity.func_110124_au();
                    Stack<BlockPos> playerLocations = tpStack.getOrDefault(player, new Stack());
                    playerLocations.push(entity.func_233580_cy_());
                    tpStack.put(player, playerLocations);
                    ILocationArgument location = Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location");
                    Vector3d position = location.func_197281_a(source);
                    CommandMek.teleport(entity, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                    source.func_197030_a((ITextComponent)MekanismLang.COMMAND_TP.translate(position.func_82615_a(), position.func_82617_b(), position.func_82616_c()), true);
                }
                return 0;
            }));
        }
    }

    private static class TestRulesCommand {
        private TestRulesCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"testrules").requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                MinecraftServer server = source.func_197028_i();
                GameRules rules = server.func_200252_aR();
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223600_c)).func_223570_a(true, server);
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223601_d)).func_223570_a(false, server);
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223607_j)).func_223570_a(false, server);
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223617_t)).func_223570_a(false, server);
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223599_b)).func_223570_a(false, server);
                ((ServerWorld)source.func_197035_h().func_130014_f_()).func_241114_a_(2000L);
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_TEST_RULES.translate(new Object[0]), true);
                return 0;
            });
        }
    }

    private static class DebugCommand {
        private DebugCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"debug").requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
                MekanismAPI.debug = !MekanismAPI.debug;
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)MekanismLang.COMMAND_DEBUG.translate(BooleanStateDisplay.OnOff.of(MekanismAPI.debug)), true);
                return 0;
            });
        }
    }
}

