/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command.builders;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import mekanism.common.command.builders.StructureBuilder;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;

public class BuildCommand {
    public static final ArgumentBuilder<CommandSource, ?> COMMAND = Commands.func_197057_a((String)"build").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
        ServerPlayerEntity player;
        BlockRayTraceResult result;
        CommandSource source = (CommandSource)ctx.getSource();
        Entity entity = source.func_197022_f();
        if (entity instanceof ServerPlayerEntity && (result = MekanismUtils.rayTrace((PlayerEntity)(player = (ServerPlayerEntity)((CommandSource)ctx.getSource()).func_197022_f()), 100.0)).func_216346_c() != RayTraceResult.Type.MISS) {
            BuildCommand.destroy((World)source.func_197023_e(), result.func_216350_a());
        }
        return 0;
    }));

    private BuildCommand() {
    }

    public static void register(String name, StructureBuilder builder) {
        COMMAND.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
            ServerPlayerEntity player;
            BlockRayTraceResult result;
            CommandSource source = (CommandSource)ctx.getSource();
            Entity entity = source.func_197022_f();
            if (entity instanceof ServerPlayerEntity && (result = MekanismUtils.rayTrace((PlayerEntity)(player = (ServerPlayerEntity)((CommandSource)ctx.getSource()).func_197022_f()), 100.0)).func_216346_c() != RayTraceResult.Type.MISS) {
                BlockPos pos = result.func_216350_a().func_177972_a(Direction.UP);
                builder.build((World)source.func_197023_e(), pos);
            }
            return 0;
        }));
    }

    private static void destroy(World world, BlockPos pos) {
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        HashSet<BlockPos> traversed = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> openSet = new ArrayDeque<BlockPos>();
        openSet.add(pos);
        traversed.add(pos);
        while (!openSet.isEmpty()) {
            BlockPos ptr = (BlockPos)openSet.poll();
            Optional<BlockState> state = WorldUtils.getBlockState((IWorld)world, (Long2ObjectMap<IChunk>)chunkMap, ptr);
            if (!state.isPresent() || !state.get().func_177230_c().getRegistryName().func_110624_b().startsWith("mekanism")) continue;
            world.func_217377_a(ptr, false);
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockPos offset = ptr.func_177972_a(side);
                if (!traversed.add(offset)) continue;
                openSet.add(offset);
            }
        }
    }
}

