/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import mekanism.api.math.FloatingLong;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.mekasuit.ModuleMekaSuit;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ModuleLocomotiveBoostingUnit
extends ModuleMekaSuit {
    private ModuleConfigItem<SprintBoost> sprintBoost;

    @Override
    public void init() {
        super.init();
        this.sprintBoost = new ModuleConfigItem<SprintBoost>(this, "sprint_boost", MekanismLang.MODULE_SPRINT_BOOST, new ModuleConfigItem.EnumData<SprintBoost>(SprintBoost.class, this.getInstalledCount() + 1), SprintBoost.LOW);
        this.addConfigItem(this.sprintBoost);
    }

    @Override
    public void tickServer(PlayerEntity player) {
        super.tickServer(player);
        if (this.canFunction(player)) {
            float boost = this.getBoost();
            if (!player.func_233570_aj_()) {
                boost /= 5.0f;
            }
            if (player.func_70090_H()) {
                boost /= 5.0f;
            }
            player.func_213309_a(boost, new Vector3d(0.0, 0.0, 1.0));
            this.useEnergy((LivingEntity)player, ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageSprintBoost.get()).multiply(this.getBoost() / 0.1f));
        }
    }

    @Override
    public void tickClient(PlayerEntity player) {
        super.tickClient(player);
        if (this.canFunction(player)) {
            float boost = this.getBoost();
            if (!player.func_233570_aj_()) {
                boost /= 5.0f;
            }
            if (player.func_70090_H()) {
                boost /= 5.0f;
            }
            player.func_213309_a(boost, new Vector3d(0.0, 0.0, 1.0));
        }
    }

    public boolean canFunction(PlayerEntity player) {
        FloatingLong usage = ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageSprintBoost.get()).multiply(this.getBoost() / 0.1f);
        return player.func_70051_ag() && this.getContainerEnergy().greaterOrEqual(usage);
    }

    public float getBoost() {
        return this.sprintBoost.get().getBoost();
    }

    public static enum SprintBoost implements IHasTextComponent
    {
        OFF(0.0f),
        LOW(0.05f),
        MED(0.1f),
        HIGH(0.25f),
        ULTRA(0.5f);

        private final float boost;
        private final ITextComponent label;

        private SprintBoost(float boost) {
            this.boost = boost;
            this.label = new StringTextComponent(Float.toString(boost));
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.label;
        }

        public float getBoost() {
            return this.boost;
        }
    }
}

