/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.content.network.distribution.FluidHandlerTarget;
import mekanism.common.content.network.distribution.FluidTransmitterSaveTarget;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidNetwork
extends DynamicBufferedNetwork<IFluidHandler, FluidNetwork, FluidStack, MechanicalPipe>
implements IMekanismFluidHandler {
    private final List<IExtendedFluidTank> fluidTanks;
    public final VariableCapacityFluidTank fluidTank;
    @Nonnull
    public FluidStack lastFluid = FluidStack.EMPTY;
    private int prevTransferAmount;
    private int intCapacity;

    public FluidNetwork() {
        this.fluidTank = VariableCapacityFluidTank.create(this::getCapacityAsInt, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrue, (IContentsListener)this);
        this.fluidTanks = Collections.singletonList(this.fluidTank);
    }

    public FluidNetwork(UUID networkID) {
        super(networkID);
        this.fluidTank = VariableCapacityFluidTank.create(this::getCapacityAsInt, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrue, (IContentsListener)this);
        this.fluidTanks = Collections.singletonList(this.fluidTank);
    }

    public FluidNetwork(Collection<FluidNetwork> networks) {
        this();
        this.adoptAllAndRegister(networks);
    }

    @Override
    protected void forceScaleUpdate() {
        this.currentScale = !this.fluidTank.isEmpty() && this.fluidTank.getCapacity() > 0 ? Math.min(1.0f, (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity()) : 0.0f;
    }

    @Override
    public List<MechanicalPipe> adoptTransmittersAndAcceptorsFrom(FluidNetwork net) {
        float oldScale = this.currentScale;
        long oldCapacity = this.getCapacity();
        List<MechanicalPipe> transmittersToUpdate = super.adoptTransmittersAndAcceptorsFrom(net);
        long capacity = this.getCapacity();
        this.currentScale = Math.min(1.0f, capacity == 0L ? 0.0f : (this.currentScale * (float)oldCapacity + net.currentScale * (float)net.capacity) / (float)capacity);
        if (this.isRemote()) {
            if (this.fluidTank.isEmpty() && !net.fluidTank.isEmpty()) {
                this.fluidTank.setStack(net.getBuffer());
                net.fluidTank.setEmpty();
            }
        } else {
            if (!net.fluidTank.isEmpty()) {
                if (this.fluidTank.isEmpty()) {
                    this.fluidTank.setStack(net.getBuffer());
                } else if (this.fluidTank.isFluidEqual(net.fluidTank.getFluid())) {
                    int amount = net.fluidTank.getFluidAmount();
                    MekanismUtils.logMismatchedStackSize(this.fluidTank.growStack(amount, Action.EXECUTE), amount);
                } else {
                    Mekanism.logger.error("Incompatible fluid networks merged.");
                }
                net.fluidTank.setEmpty();
            }
            if (oldScale != this.currentScale) {
                this.needsUpdate = true;
            }
        }
        return transmittersToUpdate;
    }

    @Override
    @Nonnull
    public FluidStack getBuffer() {
        return this.fluidTank.getFluid().copy();
    }

    @Override
    public void absorbBuffer(MechanicalPipe transmitter) {
        FluidStack fluid = transmitter.releaseShare();
        if (!fluid.isEmpty()) {
            if (this.fluidTank.isEmpty()) {
                this.fluidTank.setStack(fluid.copy());
            } else if (this.fluidTank.isFluidEqual(fluid)) {
                int amount = fluid.getAmount();
                MekanismUtils.logMismatchedStackSize(this.fluidTank.growStack(amount, Action.EXECUTE), amount);
            }
        }
    }

    @Override
    public void clampBuffer() {
        if (!this.fluidTank.isEmpty()) {
            int capacity = this.getCapacityAsInt();
            if (this.fluidTank.getFluidAmount() > capacity) {
                MekanismUtils.logMismatchedStackSize(this.fluidTank.setStackSize(capacity, Action.EXECUTE), capacity);
            }
        }
    }

    @Override
    protected synchronized void updateCapacity(MechanicalPipe transmitter) {
        super.updateCapacity(transmitter);
        this.intCapacity = MathUtils.clampToInt(this.getCapacity());
    }

    @Override
    public synchronized void updateCapacity() {
        super.updateCapacity();
        this.intCapacity = MathUtils.clampToInt(this.getCapacity());
    }

    public int getCapacityAsInt() {
        return this.intCapacity;
    }

    @Override
    protected void updateSaveShares(@Nullable MechanicalPipe triggerTransmitter) {
        super.updateSaveShares(triggerTransmitter);
        int size = this.transmittersSize();
        if (size > 0) {
            FluidStack fluidType = this.fluidTank.getFluid();
            Direction side = Direction.NORTH;
            ObjectOpenHashSet saveTargets = new ObjectOpenHashSet(size);
            for (MechanicalPipe transmitter : this.transmitters) {
                FluidTransmitterSaveTarget saveTarget = new FluidTransmitterSaveTarget(fluidType);
                saveTarget.addHandler(side, transmitter);
                saveTargets.add(saveTarget);
            }
            EmitUtils.sendToAcceptors(saveTargets, size, fluidType.getAmount(), fluidType);
            for (FluidTransmitterSaveTarget saveTarget : saveTargets) {
                saveTarget.saveShare(side);
            }
        }
    }

    private int tickEmit(@Nonnull FluidStack fluidToSend) {
        ObjectOpenHashSet availableAcceptors = new ObjectOpenHashSet();
        int totalHandlers = 0;
        for (Map.Entry entry : this.acceptorCache.getAcceptorEntrySet()) {
            FluidHandlerTarget target = new FluidHandlerTarget(fluidToSend);
            entry.getValue().forEach((side, lazyAcceptor) -> lazyAcceptor.ifPresent(acceptor -> {
                if (FluidUtils.canFill(acceptor, fluidToSend)) {
                    target.addHandler((Direction)side, acceptor);
                }
            }));
            int curHandlers = target.getHandlers().size();
            if (curHandlers <= 0) continue;
            availableAcceptors.add(target);
            totalHandlers += curHandlers;
        }
        return EmitUtils.sendToAcceptors(availableAcceptors, totalHandlers, fluidToSend.getAmount(), fluidToSend);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.needsUpdate) {
            MinecraftForge.EVENT_BUS.post((Event)new FluidTransferEvent(this, this.lastFluid));
            this.needsUpdate = false;
        }
        if (this.fluidTank.isEmpty()) {
            this.prevTransferAmount = 0;
        } else {
            this.prevTransferAmount = this.tickEmit(this.fluidTank.getFluid());
            MekanismUtils.logMismatchedStackSize(this.fluidTank.shrinkStack(this.prevTransferAmount, Action.EXECUTE), this.prevTransferAmount);
        }
    }

    @Override
    protected float computeContentScale() {
        float scale = (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity();
        float ret = Math.max(this.currentScale, scale);
        if (this.prevTransferAmount > 0 && ret < 1.0f) {
            ret = Math.min(1.0f, ret + 0.02f);
        } else if (this.prevTransferAmount <= 0 && ret > 0.0f) {
            ret = Math.max(scale, ret - 0.02f);
        }
        return ret;
    }

    public int getPrevTransferAmount() {
        return this.prevTransferAmount;
    }

    public String toString() {
        return "[FluidNetwork] " + this.transmitters.size() + " transmitters, " + this.getAcceptorCount() + " acceptors.";
    }

    @Override
    public ITextComponent getNeededInfo() {
        return MekanismLang.FLUID_NETWORK_NEEDED.translate(Float.valueOf((float)this.fluidTank.getNeeded() / 1000.0f));
    }

    @Override
    public ITextComponent getStoredInfo() {
        if (this.fluidTank.isEmpty()) {
            return MekanismLang.NONE.translate(new Object[0]);
        }
        return MekanismLang.NETWORK_MB_STORED.translate(this.fluidTank.getFluid(), this.fluidTank.getFluidAmount());
    }

    @Override
    public ITextComponent getFlowInfo() {
        return MekanismLang.NETWORK_MB_PER_TICK.translate(this.prevTransferAmount);
    }

    @Override
    public boolean isCompatibleWith(FluidNetwork other) {
        return super.isCompatibleWith(other) && (this.fluidTank.isEmpty() || other.fluidTank.isEmpty() || this.fluidTank.isFluidEqual(other.fluidTank.getFluid()));
    }

    @Override
    public boolean compatibleWithBuffer(@Nonnull FluidStack buffer) {
        return super.compatibleWithBuffer(buffer) && (this.fluidTank.isEmpty() || buffer.isEmpty() || this.fluidTank.isFluidEqual(buffer));
    }

    @Override
    public ITextComponent getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.FLUID_NETWORK, this.transmitters.size(), this.getAcceptorCount());
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    public void onContentsChanged() {
        this.markDirty();
        FluidStack type = this.fluidTank.getFluid();
        if (!this.lastFluid.isFluidEqual(type)) {
            if (!type.isEmpty()) {
                this.lastFluid = new FluidStack(type, 1);
            }
            this.needsUpdate = true;
        }
    }

    public void setLastFluid(@Nonnull FluidStack fluid) {
        if (fluid.isEmpty()) {
            this.fluidTank.setEmpty();
        } else {
            this.lastFluid = fluid;
            this.fluidTank.setStack(new FluidStack(fluid, 1));
        }
    }

    public static class FluidTransferEvent
    extends DynamicBufferedNetwork.TransferEvent<FluidNetwork> {
        public final FluidStack fluidType;

        public FluidTransferEvent(FluidNetwork network, @Nonnull FluidStack type) {
            super(network);
            this.fluidType = type;
        }
    }
}

