/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.acceptor.EnergyAcceptorCache;
import mekanism.common.tier.CableTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.upgrade.transmitter.UniversalCableUpgradeData;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

public class UniversalCable
extends BufferedTransmitter<IStrictEnergyHandler, EnergyNetwork, FloatingLong, UniversalCable>
implements IMekanismStrictEnergyHandler,
IUpgradeableTransmitter<UniversalCableUpgradeData> {
    public final CableTier tier;
    private final List<IEnergyContainer> energyContainers;
    public final BasicEnergyContainer buffer;
    public FloatingLong lastWrite = FloatingLong.ZERO;

    public UniversalCable(IBlockProvider blockProvider, TileEntityTransmitter tile) {
        super(tile, TransmissionType.ENERGY);
        this.tier = Attribute.getTier(blockProvider.getBlock(), CableTier.class);
        this.buffer = BasicEnergyContainer.create(this.getCapacityAsFloatingLong(), BasicEnergyContainer.alwaysFalse, BasicEnergyContainer.alwaysTrue, this);
        this.energyContainers = Collections.singletonList(this.buffer);
    }

    protected EnergyAcceptorCache createAcceptorCache() {
        return new EnergyAcceptorCache(this, this.getTransmitterTile());
    }

    public EnergyAcceptorCache getAcceptorCache() {
        return (EnergyAcceptorCache)super.getAcceptorCache();
    }

    @Override
    public CableTier getTier() {
        return this.tier;
    }

    @Override
    public void pullFromAcceptors() {
        Set<Direction> connections = this.getConnections(ConnectionType.PULL);
        if (!connections.isEmpty()) {
            for (IStrictEnergyHandler connectedAcceptor : this.getAcceptorCache().getConnectedAcceptors(connections)) {
                FloatingLong received = connectedAcceptor.extractEnergy(this.getAvailablePull(), Action.SIMULATE);
                if (received.isZero() || !this.takeEnergy(received, Action.SIMULATE).isZero()) continue;
                FloatingLong remainder = this.takeEnergy(received, Action.EXECUTE);
                connectedAcceptor.extractEnergy(received.subtract(remainder), Action.EXECUTE);
            }
        }
    }

    private FloatingLong getAvailablePull() {
        if (this.hasTransmitterNetwork()) {
            return this.getCapacityAsFloatingLong().min(((EnergyNetwork)this.getTransmitterNetwork()).energyContainer.getNeeded());
        }
        return this.getCapacityAsFloatingLong().min(this.buffer.getNeeded());
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        if (this.hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitterNetwork()).getEnergyContainers(side);
        }
        return this.energyContainers;
    }

    @Override
    public void onContentsChanged() {
        this.getTransmitterTile().markDirty(false);
    }

    @Override
    @Nonnull
    public FloatingLong insertEnergy(int container, @Nonnull FloatingLong amount, @Nullable Direction side, @Nonnull Action action) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        if (energyContainer == null) {
            return amount;
        }
        if (side == null) {
            return energyContainer.insert(amount, action, AutomationType.INTERNAL);
        }
        ConnectionType connectionType = this.getConnectionType(side);
        if (connectionType == ConnectionType.NORMAL || connectionType == ConnectionType.PULL) {
            return energyContainer.insert(amount, action, AutomationType.EXTERNAL);
        }
        return amount;
    }

    @Override
    @Nullable
    public UniversalCableUpgradeData getUpgradeData() {
        return new UniversalCableUpgradeData(this.redstoneReactive, this.connectionTypes, this.buffer);
    }

    @Override
    public boolean dataTypeMatches(@Nonnull TransmitterUpgradeData data) {
        return data instanceof UniversalCableUpgradeData;
    }

    @Override
    public void parseUpgradeData(@Nonnull UniversalCableUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.connectionTypes = data.connectionTypes;
        this.buffer.setEnergy(data.buffer.getEnergy());
    }

    @Override
    public void read(@Nonnull CompoundNBT nbtTags) {
        super.read(nbtTags);
        if (nbtTags.func_150297_b("energy", 8)) {
            try {
                this.lastWrite = FloatingLong.parseFloatingLong(nbtTags.func_74779_i("energy"));
            }
            catch (NumberFormatException e) {
                this.lastWrite = FloatingLong.ZERO;
            }
        } else {
            this.lastWrite = FloatingLong.ZERO;
        }
        this.buffer.setEnergy(this.lastWrite);
    }

    @Override
    @Nonnull
    public CompoundNBT write(@Nonnull CompoundNBT nbtTags) {
        super.write(nbtTags);
        if (this.hasTransmitterNetwork()) {
            ((EnergyNetwork)this.getTransmitterNetwork()).validateSaveShares(this);
        }
        if (this.lastWrite.isZero()) {
            nbtTags.func_82580_o("energy");
        } else {
            nbtTags.func_74778_a("energy", this.lastWrite.toString());
        }
        return nbtTags;
    }

    @Override
    public EnergyNetwork createNetworkByMerging(Collection<EnergyNetwork> networks) {
        return new EnergyNetwork(networks);
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, Direction side) {
        return super.isValidAcceptor(tile, side) && this.getAcceptorCache().hasStrictEnergyHandlerAndListen(tile, side);
    }

    @Override
    public EnergyNetwork createEmptyNetwork() {
        return new EnergyNetwork();
    }

    @Override
    public EnergyNetwork createEmptyNetworkWithID(UUID networkID) {
        return new EnergyNetwork(networkID);
    }

    @Override
    @Nonnull
    public FloatingLong releaseShare() {
        FloatingLong energy = this.buffer.getEnergy();
        this.buffer.setEmpty();
        return energy;
    }

    @Override
    @Nonnull
    public FloatingLong getShare() {
        return this.buffer.getEnergy();
    }

    @Override
    public boolean noBufferOrFallback() {
        return this.getBufferWithFallback().isZero();
    }

    @Override
    @Nonnull
    public FloatingLong getBufferWithFallback() {
        FloatingLong buffer = this.getShare();
        if (buffer.isZero() && this.hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitterNetwork()).getBuffer();
        }
        return buffer;
    }

    @Override
    public void takeShare() {
        if (this.hasTransmitterNetwork()) {
            EnergyNetwork transmitterNetwork = (EnergyNetwork)this.getTransmitterNetwork();
            if (!transmitterNetwork.energyContainer.isEmpty() && !this.lastWrite.isZero()) {
                transmitterNetwork.energyContainer.setEnergy(transmitterNetwork.energyContainer.getEnergy().subtract(this.lastWrite));
                this.buffer.setEnergy(this.lastWrite);
            }
        }
    }

    @Nonnull
    public FloatingLong getCapacityAsFloatingLong() {
        return this.tier.getCableCapacity();
    }

    @Override
    public long getCapacity() {
        return this.getCapacityAsFloatingLong().longValue();
    }

    private FloatingLong takeEnergy(FloatingLong amount, Action action) {
        if (this.hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitterNetwork()).energyContainer.insert(amount, action, AutomationType.INTERNAL);
        }
        return this.buffer.insert(amount, action, AutomationType.INTERNAL);
    }

    @Override
    protected void handleContentsUpdateTag(@Nonnull EnergyNetwork network, @Nonnull CompoundNBT tag) {
        super.handleContentsUpdateTag(network, tag);
        NBTUtils.setFloatingLongIfPresent(tag, "energy", network.energyContainer::setEnergy);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            network.currentScale = scale;
        });
    }
}

