/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import mekanism.common.base.TagCache;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class SearchQueryParser {
    private static final ISearchQuery INVALID = stack -> false;
    private static final Set<Character> TERMINATORS = Sets.newHashSet((Object[])new Character[]{Character.valueOf('|'), Character.valueOf('('), Character.valueOf('\"'), Character.valueOf('\'')});

    public static ISearchQuery parse(String query) {
        ArrayList<SearchQuery> ret = new ArrayList<SearchQuery>();
        SearchQuery curQuery = new SearchQuery();
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (c == '|') {
                if (!curQuery.isEmpty()) {
                    ret.add(curQuery);
                }
                curQuery = new SearchQuery();
                continue;
            }
            if (c == ' ') continue;
            QueryType type = QueryType.get(c);
            if (type != null) {
                ++i;
            } else {
                type = QueryType.NAME;
            }
            Pair<Boolean, Integer> keyListResult = SearchQueryParser.readKeyList(query, i, type, curQuery);
            if (!((Boolean)keyListResult.getLeft()).booleanValue()) {
                return INVALID;
            }
            i = (Integer)keyListResult.getRight();
        }
        if (!curQuery.isEmpty()) {
            ret.add(curQuery);
        }
        return new SearchQueryList(ret);
    }

    private static Pair<Boolean, Integer> readKeyList(String query, int start, QueryType type, SearchQuery curQuery) {
        int newIndex;
        List<Object> keys;
        if (start >= query.length()) {
            return Pair.of((Object)true, (Object)start);
        }
        char qc = query.charAt(start);
        if (qc == '(') {
            Pair<List<String>, Integer> listResult = SearchQueryParser.readList(query, start);
            if (listResult == null) {
                return Pair.of((Object)false, (Object)-1);
            }
            keys = (List<Object>)listResult.getLeft();
            newIndex = (Integer)listResult.getRight();
        } else if (qc == '\"' || qc == '\'') {
            Pair<String, Integer> quoteResult = SearchQueryParser.readQuote(query, start);
            if (quoteResult == null) {
                return Pair.of((Object)false, (Object)-1);
            }
            keys = Collections.singletonList(quoteResult.getLeft());
            newIndex = (Integer)quoteResult.getRight();
        } else {
            Pair<String, Integer> textResult = SearchQueryParser.readUntilTermination(query, start, type != QueryType.NAME);
            keys = Collections.singletonList(textResult.getLeft());
            newIndex = (Integer)textResult.getRight();
        }
        if (!keys.isEmpty()) {
            curQuery.queryStrings.put(type, keys);
        }
        return Pair.of((Object)true, (Object)newIndex);
    }

    private static Pair<List<String>, Integer> readList(String query, int start) {
        ArrayList<Object> ret = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        for (int i = start + 1; i < query.length(); ++i) {
            String key;
            char qc = query.charAt(i);
            if (qc == ')') {
                key = sb.toString().trim();
                if (!key.isEmpty()) {
                    ret.add(key);
                }
                return Pair.of(ret, (Object)i);
            }
            if (qc == '|') {
                key = sb.toString().trim();
                if (!key.isEmpty()) {
                    ret.add(key);
                }
                sb = new StringBuilder();
                continue;
            }
            if (qc == '\"' || qc == '\'') {
                Pair<String, Integer> quoteResult = SearchQueryParser.readQuote(query, i);
                if (quoteResult == null) {
                    return null;
                }
                ret.add(quoteResult.getLeft());
                i = (Integer)quoteResult.getRight();
                continue;
            }
            sb.append(qc);
        }
        return null;
    }

    private static Pair<String, Integer> readQuote(String text, int start) {
        char quoteChar = text.charAt(start);
        StringBuilder ret = new StringBuilder();
        for (int i = start + 1; i < text.length(); ++i) {
            char tc = text.charAt(i);
            if (tc == quoteChar) {
                return Pair.of((Object)ret.toString(), (Object)i);
            }
            ret.append(tc);
        }
        return null;
    }

    private static Pair<String, Integer> readUntilTermination(String text, int start, boolean spaceTerminate) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = start; i < text.length(); ++i) {
            char tc = text.charAt(i);
            if (TERMINATORS.contains(Character.valueOf(tc)) || QueryType.get(tc) != null || spaceTerminate && tc == ' ') {
                --i;
                break;
            }
            sb.append(tc);
        }
        return Pair.of((Object)sb.toString().trim(), (Object)i);
    }

    public static interface ISearchQuery {
        public boolean matches(ItemStack var1);

        default public boolean isInvalid() {
            return this == INVALID;
        }
    }

    public static class SearchQueryList
    implements ISearchQuery {
        private final List<SearchQuery> queries;

        private SearchQueryList(List<SearchQuery> queries) {
            this.queries = queries;
        }

        @Override
        public boolean matches(ItemStack stack) {
            return this.queries.isEmpty() || this.queries.stream().anyMatch(query -> query.matches(stack));
        }

        public String toString() {
            return this.queries.toString();
        }

        protected List<SearchQuery> getQueries() {
            return this.queries;
        }
    }

    public static class SearchQuery
    implements ISearchQuery {
        private final Map<QueryType, List<String>> queryStrings = new LinkedHashMap<QueryType, List<String>>();

        @Override
        public boolean matches(ItemStack stack) {
            return this.queryStrings.entrySet().stream().allMatch(entry -> ((List)entry.getValue()).stream().anyMatch(key -> ((QueryType)((Object)((Object)((Object)entry.getKey())))).matches((String)key, stack)));
        }

        private boolean isEmpty() {
            return this.queryStrings.isEmpty();
        }

        protected Map<QueryType, List<String>> getQueryMap() {
            return this.queryStrings;
        }

        public String toString() {
            return this.queryStrings.toString();
        }
    }

    public static enum QueryType {
        NAME('~', (key, stack) -> stack.func_200301_q().getString().toLowerCase(Locale.ROOT).contains(key.toLowerCase(Locale.ROOT))),
        MOD_ID('@', (key, stack) -> MekanismUtils.getModId(stack).toLowerCase(Locale.ROOT).contains(key.toLowerCase(Locale.ROOT))),
        TOOLTIP('$', (key, stack) -> stack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL).stream().map(t -> t.getString().toLowerCase(Locale.ROOT)).anyMatch(tooltip -> tooltip.contains(key.toLowerCase(Locale.ROOT)))),
        TAG('#', (key, stack) -> TagCache.getItemTags(stack).stream().anyMatch(itemTag -> itemTag.toLowerCase(Locale.ROOT).contains(key.toLowerCase(Locale.ROOT))));

        private static final Char2ObjectMap<QueryType> charLookupMap;
        private final char prefix;
        private final BiPredicate<String, ItemStack> checker;

        public static QueryType get(char prefix) {
            return (QueryType)((Object)charLookupMap.get(prefix));
        }

        public static CharSet getPrefixChars() {
            return charLookupMap.keySet();
        }

        private QueryType(char prefix, BiPredicate<String, ItemStack> checker) {
            this.prefix = prefix;
            this.checker = checker;
        }

        public boolean matches(String key, ItemStack stack) {
            return this.checker.test(key, stack);
        }

        static {
            charLookupMap = new Char2ObjectOpenHashMap();
            for (QueryType type : QueryType.values()) {
                charLookupMap.put(type.prefix, (Object)type);
            }
        }
    }
}

