/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.sps;

import java.util.List;
import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.util.NBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class SPSCache
extends MultiblockCache<SPSMultiblockData> {
    private double progress;
    private int inputProcessed;

    @Override
    public void merge(MultiblockCache<SPSMultiblockData> mergeCache, List<ItemStack> rejectedItems) {
        super.merge(mergeCache, rejectedItems);
        this.progress = ((SPSCache)mergeCache).progress;
        this.inputProcessed = ((SPSCache)mergeCache).inputProcessed;
    }

    @Override
    public void apply(SPSMultiblockData data) {
        super.apply(data);
        data.progress = this.progress;
        data.inputProcessed = this.inputProcessed;
    }

    @Override
    public void sync(SPSMultiblockData data) {
        super.sync(data);
        this.progress = data.progress;
        this.inputProcessed = data.inputProcessed;
    }

    @Override
    public void load(CompoundNBT nbtTags) {
        super.load(nbtTags);
        NBTUtils.setDoubleIfPresent(nbtTags, "progress", val -> {
            this.progress = val;
        });
        NBTUtils.setIntIfPresent(nbtTags, "processed", val -> {
            this.inputProcessed = val;
        });
    }

    @Override
    public void save(CompoundNBT nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74780_a("progress", this.progress);
        nbtTags.func_74768_a("processed", this.inputProcessed);
    }
}

