/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.item.MekanismItemContainer;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.IOwnerItem;
import mekanism.common.network.PacketGuiItemDataRequest;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public abstract class FrequencyItemContainer<FREQ extends Frequency>
extends MekanismItemContainer {
    private FREQ frequency;
    private List<FREQ> publicCache = new ArrayList<FREQ>();
    private List<FREQ> privateCache = new ArrayList<FREQ>();

    protected FrequencyItemContainer(ContainerTypeRegistryObject<?> type, int id, @Nullable PlayerInventory inv, Hand hand, ItemStack stack) {
        super(type, id, inv, hand, stack);
    }

    public void handleCacheUpdate(List<FREQ> publicCache, List<FREQ> privateCache, FREQ frequency) {
        this.publicCache = publicCache;
        this.privateCache = privateCache;
        this.frequency = frequency;
    }

    public abstract FrequencyType<FREQ> getFrequencyType();

    @Override
    public void openInventory(@Nonnull PlayerInventory inv) {
        super.openInventory(inv);
        if (inv.field_70458_d.field_70170_p.func_201670_d()) {
            Mekanism.packetHandler.sendToServer(PacketGuiItemDataRequest.frequencyList(this.hand));
        }
    }

    public UUID getOwnerUUID() {
        return ((IOwnerItem)this.stack.func_77973_b()).getOwnerUUID(this.stack);
    }

    public String getOwnerUsername() {
        return MekanismClient.clientUUIDMap.get(((IOwnerItem)this.stack.func_77973_b()).getOwnerUUID(this.stack));
    }

    public FREQ getFrequency() {
        return this.frequency;
    }

    public List<FREQ> getPublicCache() {
        return this.publicCache;
    }

    public List<FREQ> getPrivateCache() {
        return this.privateCache;
    }
}

