/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import javax.annotation.Nonnull;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.item.MekanismItemContainer;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.item.ItemPortableQIODashboard;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.util.SecurityUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;

public class PortableQIODashboardContainer
extends QIOItemViewerContainer {
    protected final Hand hand;
    protected final ItemStack stack;

    private PortableQIODashboardContainer(int id, PlayerInventory inv, Hand hand, ItemStack stack, boolean remote) {
        super(MekanismContainerTypes.PORTABLE_QIO_DASHBOARD, id, inv, remote);
        this.hand = hand;
        this.stack = stack;
        this.addSlotsAndOpen();
    }

    public PortableQIODashboardContainer(int id, PlayerInventory inv, Hand hand, ItemStack stack) {
        this(id, inv, hand, stack, false);
    }

    public PortableQIODashboardContainer(int id, PlayerInventory inv, PacketBuffer buf) {
        this(id, inv, (Hand)buf.func_179257_a(Hand.class), MekanismItemContainer.getStackFromBuffer(buf, ItemPortableQIODashboard.class), true);
    }

    public Hand getHand() {
        return this.hand;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public PortableQIODashboardContainer recreate() {
        PortableQIODashboardContainer container = new PortableQIODashboardContainer(this.field_75152_c, this.inv, this.hand, this.stack);
        this.sync(container);
        return container;
    }

    @Override
    public QIOFrequency getFrequency() {
        if (!this.inv.field_70458_d.field_70170_p.func_201670_d()) {
            Frequency.FrequencyIdentity identity = ((IFrequencyItem)this.stack.func_77973_b()).getFrequency(this.stack);
            if (identity == null) {
                return null;
            }
            FrequencyManager<QIOFrequency> manager = identity.isPublic() ? FrequencyType.QIO.getManager(null) : FrequencyType.QIO.getManager(this.inv.field_70458_d.func_110124_au());
            QIOFrequency freq = manager.getFrequency(identity.getKey());
            if (freq == null) {
                ((IFrequencyItem)this.stack.func_77973_b()).setFrequency(this.stack, null);
            }
            return freq;
        }
        return null;
    }

    @Override
    protected HotBarSlot createHotBarSlot(@Nonnull PlayerInventory inv, int index, int x, int y) {
        if (index == inv.field_70461_c) {
            return new HotBarSlot((IInventory)inv, index, x, y){

                public boolean func_82869_a(@Nonnull PlayerEntity player) {
                    return false;
                }
            };
        }
        return super.createHotBarSlot(inv, index, x, y);
    }

    @Override
    public ISecurityObject getSecurityObject() {
        return SecurityUtils.wrapSecurityItem(this.stack);
    }
}

