/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.items.ItemHandlerHelper;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BasicInventorySlot
implements IInventorySlot {
    public static final Predicate<@NonNull ItemStack> alwaysTrue = stack -> true;
    public static final Predicate<@NonNull ItemStack> alwaysFalse = stack -> false;
    public static final BiPredicate<@NonNull ItemStack, @NonNull AutomationType> alwaysTrueBi = (stack, automationType) -> true;
    public static final BiPredicate<@NonNull ItemStack, @NonNull AutomationType> manualOnly = (stack, automationType) -> automationType == AutomationType.MANUAL;
    public static final BiPredicate<@NonNull ItemStack, @NonNull AutomationType> internalOnly = (stack, automationType) -> automationType == AutomationType.INTERNAL;
    public static final BiPredicate<@NonNull ItemStack, @NonNull AutomationType> notExternal = (stack, automationType) -> automationType != AutomationType.EXTERNAL;
    public static final int DEFAULT_LIMIT = 64;
    protected ItemStack current = ItemStack.field_190927_a;
    private final BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canExtract;
    private final BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInsert;
    private final Predicate<@NonNull ItemStack> validator;
    private final int limit;
    @Nullable
    private final IContentsListener listener;
    private final int x;
    private final int y;
    protected boolean obeyStackLimit = true;
    private ContainerSlotType slotType = ContainerSlotType.NORMAL;
    @Nullable
    private SlotOverlay slotOverlay;

    public static BasicInventorySlot at(@Nullable IContentsListener listener, int x, int y) {
        return BasicInventorySlot.at(alwaysTrue, listener, x, y);
    }

    public static BasicInventorySlot at(Predicate<@NonNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(validator, "Item validity check cannot be null");
        return new BasicInventorySlot(alwaysTrueBi, alwaysTrueBi, validator, listener, x, y);
    }

    public static BasicInventorySlot at(Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        return new BasicInventorySlot(canExtract, canInsert, alwaysTrue, listener, x, y);
    }

    public static BasicInventorySlot at(BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canExtract, BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInsert, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        return new BasicInventorySlot(canExtract, canInsert, alwaysTrue, listener, x, y);
    }

    protected BasicInventorySlot(Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        this((ItemStack stack, AutomationType automationType) -> automationType == AutomationType.MANUAL || canExtract.test((ItemStack)stack), (ItemStack stack, AutomationType automationType) -> canInsert.test((ItemStack)stack), validator, listener, x, y);
    }

    protected BasicInventorySlot(BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canExtract, BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        this(64, canExtract, canInsert, validator, listener, x, y);
    }

    protected BasicInventorySlot(int limit, BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canExtract, BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        this.limit = limit;
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.validator = validator;
        this.listener = listener;
        this.x = x;
        this.y = y;
    }

    @Override
    public ItemStack getStack() {
        return this.current;
    }

    @Override
    public void setStack(ItemStack stack) {
        this.setStack(stack, true);
    }

    protected void setStackUnchecked(ItemStack stack) {
        this.setStack(stack, false);
    }

    private void setStack(ItemStack stack, boolean validateStack) {
        if (stack.func_190926_b()) {
            this.current = ItemStack.field_190927_a;
        } else if (!validateStack || this.isItemValid(stack)) {
            this.current = stack.func_77946_l();
        } else {
            throw new RuntimeException("Invalid stack for slot: " + stack.func_77973_b().getRegistryName() + " " + stack.func_190916_E() + " " + stack.func_77978_p());
        }
        this.onContentsChanged();
    }

    @Override
    public ItemStack insertItem(ItemStack stack, Action action, AutomationType automationType) {
        if (stack.func_190926_b() || !this.isItemValid(stack) || !this.canInsert.test(stack, automationType)) {
            return stack;
        }
        int needed = this.getLimit(stack) - this.getCount();
        if (needed <= 0) {
            return stack;
        }
        boolean sameType = false;
        if (this.isEmpty() || (sameType = ItemHandlerHelper.canItemStacksStack((ItemStack)this.current, (ItemStack)stack))) {
            int toAdd = Math.min(stack.func_190916_E(), needed);
            if (action.execute()) {
                if (sameType) {
                    this.current.func_190917_f(toAdd);
                    this.onContentsChanged();
                } else {
                    this.setStackUnchecked(StackUtils.size(stack, toAdd));
                }
            }
            return StackUtils.size(stack, stack.func_190916_E() - toAdd);
        }
        return stack;
    }

    @Override
    public ItemStack extractItem(int amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount < 1 || !this.canExtract.test(this.current, automationType)) {
            return ItemStack.field_190927_a;
        }
        int currentAmount = Math.min(this.getCount(), this.current.func_77976_d());
        if (currentAmount < amount) {
            amount = currentAmount;
        }
        ItemStack toReturn = StackUtils.size(this.current, amount);
        if (action.execute()) {
            this.current.func_190918_g(amount);
            this.onContentsChanged();
        }
        return toReturn;
    }

    @Override
    public int getLimit(ItemStack stack) {
        return this.obeyStackLimit && !stack.func_190926_b() ? Math.min(this.limit, stack.func_77976_d()) : this.limit;
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        return this.validator.test(stack);
    }

    public boolean isItemValidForInsertion(ItemStack stack, AutomationType automationType) {
        return this.validator.test(stack) && this.canInsert.test(stack, automationType);
    }

    @Override
    public void onContentsChanged() {
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    @Override
    @Nullable
    public InventoryContainerSlot createContainerSlot() {
        return new InventoryContainerSlot(this, this.x, this.y, this.slotType, this.slotOverlay);
    }

    public void setSlotType(ContainerSlotType slotType) {
        this.slotType = slotType;
    }

    public void setSlotOverlay(@Nullable SlotOverlay slotOverlay) {
        this.slotOverlay = slotOverlay;
    }

    @Override
    public int setStackSize(int amount, Action action) {
        if (this.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (action.execute()) {
                this.setStack(ItemStack.field_190927_a);
            }
            return 0;
        }
        int maxStackSize = this.getLimit(this.current);
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getCount() == amount || action.simulate()) {
            return amount;
        }
        this.current.func_190920_e(amount);
        this.onContentsChanged();
        return amount;
    }

    @Override
    public int growStack(int amount, Action action) {
        int current = this.getCount();
        if (amount > 0) {
            amount = Math.min(amount, this.getLimit(this.current));
        }
        int newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    @Override
    public boolean isEmpty() {
        return this.current.func_190926_b();
    }

    @Override
    public int getCount() {
        return this.current.func_190916_E();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.isEmpty()) {
            nbt.func_218657_a("Item", (INBT)this.current.func_77955_b(new CompoundNBT()));
            if (this.getCount() > this.current.func_77976_d()) {
                nbt.func_74768_a("SizeOverride", this.getCount());
            }
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ItemStack stack = ItemStack.field_190927_a;
        if (nbt.func_150297_b("Item", 10)) {
            stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item"));
            NBTUtils.setIntIfPresent(nbt, "SizeOverride", arg_0 -> ((ItemStack)stack).func_190920_e(arg_0));
        }
        this.setStackUnchecked(stack);
    }
}

