/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.inventory.TileTransitRequest;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TransitRequest {
    private final TransitResponse EMPTY = new TransitResponse(ItemStack.field_190927_a, null);

    public static SimpleTransitRequest simple(ItemStack stack) {
        return new SimpleTransitRequest(stack);
    }

    public static TransitRequest anyItem(TileEntity tile, Direction side, int amount) {
        return TransitRequest.definedItem(tile, side, amount, Finder.ANY);
    }

    public static TransitRequest definedItem(TileEntity tile, Direction side, int amount, Finder finder) {
        return TransitRequest.definedItem(tile, side, 1, amount, finder);
    }

    public static TransitRequest definedItem(TileEntity tile, Direction side, int min, int max, Finder finder) {
        TileTransitRequest ret = new TileTransitRequest(tile, side);
        IItemHandler inventory = InventoryUtils.assertItemHandler("TransitRequest", tile, side);
        if (inventory == null) {
            return ret;
        }
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = inventory.extractItem(i, max, true);
            if (stack.func_190926_b() || !finder.modifies(stack)) continue;
            HashedItem hashed = new HashedItem(stack);
            int toUse = Math.min(stack.func_190916_E(), max - ret.getCount(hashed));
            if (toUse == 0) continue;
            ret.addItem(StackUtils.size(stack, toUse), i);
        }
        ret.getItemMap().entrySet().removeIf(entry -> ((TileTransitRequest.TileItemData)entry.getValue()).getTotalCount() < min);
        return ret;
    }

    public abstract Collection<? extends ItemData> getItemData();

    @Nonnull
    public TransitResponse addToInventory(TileEntity tile, Direction side, boolean force) {
        if (force && tile instanceof TileEntityLogisticalSorter) {
            return ((TileEntityLogisticalSorter)tile).sendHome(this);
        }
        if (this.isEmpty()) {
            return this.getEmptyResponse();
        }
        Optional capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d()).resolve();
        if (capability.isPresent()) {
            IItemHandler inventory = (IItemHandler)capability.get();
            for (ItemData itemData : this.getItemData()) {
                ItemStack origInsert = StackUtils.size(itemData.getStack(), itemData.getTotalCount());
                ItemStack toInsert = origInsert.func_77946_l();
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    if (!inventory.isItemValid(i, toInsert) || !(toInsert = inventory.insertItem(i, toInsert, false)).func_190926_b()) continue;
                    return this.createResponse(origInsert, itemData);
                }
                if (!TransporterManager.didEmit(origInsert, toInsert)) continue;
                return this.createResponse(TransporterManager.getToUse(origInsert, toInsert), itemData);
            }
        }
        return this.getEmptyResponse();
    }

    public boolean isEmpty() {
        return this.getItemData().isEmpty();
    }

    @Nonnull
    public TransitResponse createResponse(ItemStack inserted, ItemData data) {
        return new TransitResponse(inserted, data);
    }

    public TransitResponse createSimpleResponse() {
        ItemData data = this.getItemData().stream().findFirst().orElse(null);
        return data == null ? this.getEmptyResponse() : this.createResponse(data.itemType.createStack(data.totalCount), data);
    }

    @Nonnull
    public TransitResponse getEmptyResponse() {
        return this.EMPTY;
    }

    public static class SimpleTransitRequest
    extends TransitRequest {
        private final List<ItemData> slotData = new ArrayList<ItemData>();

        protected SimpleTransitRequest(ItemStack stack) {
            this.slotData.add(new SimpleItemData(stack));
        }

        public Collection<ItemData> getItemData() {
            return this.slotData;
        }

        public static class SimpleItemData
        extends ItemData {
            public SimpleItemData(ItemStack stack) {
                super(new HashedItem(stack));
                this.totalCount = stack.func_190916_E();
            }
        }
    }

    public static class ItemData {
        private final HashedItem itemType;
        protected int totalCount;

        public ItemData(HashedItem itemType) {
            this.itemType = itemType;
        }

        public HashedItem getItemType() {
            return this.itemType;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public ItemStack getStack() {
            return this.getItemType().createStack(this.getTotalCount());
        }

        public ItemStack use(int amount) {
            Mekanism.logger.error("Can't 'use' with this type of TransitResponse: {}", (Object)this.getClass().getName());
            return ItemStack.field_190927_a;
        }
    }

    public static class TransitResponse {
        private final ItemStack inserted;
        private final ItemData slotData;

        public TransitResponse(@Nonnull ItemStack inserted, ItemData slotData) {
            this.inserted = inserted;
            this.slotData = slotData;
        }

        public int getSendingAmount() {
            return this.inserted.func_190916_E();
        }

        public ItemData getSlotData() {
            return this.slotData;
        }

        public ItemStack getStack() {
            return this.inserted;
        }

        public boolean isEmpty() {
            return this.inserted.func_190926_b() || this.slotData.getTotalCount() == 0;
        }

        public ItemStack getRejected() {
            if (this.isEmpty()) {
                return ItemStack.field_190927_a;
            }
            return StackUtils.size(this.slotData.getStack(), this.slotData.getStack().func_190916_E() - this.getSendingAmount());
        }

        public ItemStack use(int amount) {
            return this.slotData.use(amount);
        }

        public ItemStack useAll() {
            return this.use(this.getSendingAmount());
        }
    }
}

