/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.security;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mekanism.common.lib.HashList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;

public class SecurityFrequency
extends Frequency {
    public static final String SECURITY = "Security";
    private boolean override = false;
    private final List<UUID> trusted = new HashList<UUID>();
    private List<String> trustedCache = new HashList<String>();
    private int trustedCacheHash;
    private SecurityMode securityMode = SecurityMode.PUBLIC;

    public SecurityFrequency(UUID uuid) {
        super(FrequencyType.SECURITY, SECURITY, uuid);
    }

    public SecurityFrequency() {
        super(FrequencyType.SECURITY);
    }

    @Override
    public UUID getKey() {
        return this.getOwner();
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74757_a("override", this.override);
        nbtTags.func_74768_a("securityMode", this.securityMode.ordinal());
        if (!this.trusted.isEmpty()) {
            ListNBT trustedList = new ListNBT();
            for (UUID uuid : this.trusted) {
                trustedList.add((Object)NBTUtil.func_240626_a_((UUID)uuid));
            }
            nbtTags.func_218657_a("trusted", (INBT)trustedList);
        }
    }

    @Override
    protected void read(CompoundNBT nbtTags) {
        super.read(nbtTags);
        this.override = nbtTags.func_74767_n("override");
        NBTUtils.setEnumIfPresent(nbtTags, "securityMode", SecurityMode::byIndexStatic, mode -> {
            this.securityMode = mode;
        });
        if (nbtTags.func_150297_b("trusted", 9)) {
            ListNBT trustedList = nbtTags.func_150295_c("trusted", 11);
            for (INBT trusted : trustedList) {
                UUID uuid = NBTUtil.func_186860_b((INBT)trusted);
                this.addTrusted(uuid, MekanismUtils.getLastKnownUsername(uuid));
            }
        }
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.override);
        buffer.func_179249_a((Enum)this.securityMode);
        buffer.func_150787_b(this.trustedCache.size());
        this.trustedCache.forEach(arg_0 -> ((PacketBuffer)buffer).func_180714_a(arg_0));
    }

    @Override
    protected void read(PacketBuffer dataStream) {
        super.read(dataStream);
        this.override = dataStream.readBoolean();
        this.securityMode = (SecurityMode)dataStream.func_179257_a(SecurityMode.class);
        this.trustedCache = new ArrayList<String>();
        int count = dataStream.func_150792_a();
        for (int i = 0; i < count; ++i) {
            this.trustedCache.add(BasePacketHandler.readString(dataStream));
        }
    }

    @Override
    public int getSyncHash() {
        int code = super.getSyncHash();
        code = 31 * code + (this.override ? 1 : 0);
        code = 31 * code + (this.securityMode != null ? this.securityMode.ordinal() : 0);
        code = 31 * code + this.trustedCacheHash;
        return code;
    }

    public void setOverridden(boolean override) {
        this.override = override;
    }

    public boolean isOverridden() {
        return this.override;
    }

    public void setSecurityMode(SecurityMode securityMode) {
        this.securityMode = securityMode;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public List<UUID> getTrustedUUIDs() {
        return this.trusted;
    }

    public List<String> getTrustedUsernameCache() {
        return this.trustedCache;
    }

    public void addTrusted(UUID uuid, String name) {
        this.trusted.add(uuid);
        this.trustedCache.add(name);
        this.trustedCacheHash = this.trustedCache.hashCode();
    }

    public void removeTrusted(int index) {
        if (index >= 0 && index < this.trusted.size()) {
            this.trusted.remove(index);
        }
        if (index >= 0 && index < this.trustedCache.size()) {
            this.trustedCache.remove(index);
        }
        this.trustedCacheHash = this.trustedCache.hashCode();
    }
}

