/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketAddTrusted {
    public static final int MAX_NAME_LENGTH = 16;
    private final BlockPos tilePosition;
    private final String name;

    public PacketAddTrusted(BlockPos tilePosition, String name) {
        this.tilePosition = tilePosition;
        this.name = name;
    }

    public static boolean validateNameLength(int length) {
        return length >= 3 && length <= 16;
    }

    public static void handle(PacketAddTrusted message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            TileEntitySecurityDesk tile;
            ServerPlayerEntity player = ctx.getSender();
            if (player != null && (tile = WorldUtils.getTileEntity(TileEntitySecurityDesk.class, (IBlockReader)player.field_70170_p, message.tilePosition)) != null) {
                tile.addTrusted(message.name);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketAddTrusted pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.tilePosition);
        buf.func_211400_a(pkt.name, 16);
    }

    public static PacketAddTrusted decode(PacketBuffer buf) {
        return new PacketAddTrusted(buf.func_179259_c(), buf.func_150789_c(16));
    }
}

