/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.lib.HashList;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketEditFilter {
    private final IFilter<?> filter;
    private final IFilter<?> edited;
    private final boolean delete;
    private final BlockPos pos;

    public PacketEditFilter(BlockPos pos, boolean deletion, IFilter<?> filter, IFilter<?> edited) {
        this.pos = pos;
        this.delete = deletion;
        this.filter = filter;
        this.edited = edited;
    }

    public static void handle(PacketEditFilter message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            if (player == null) {
                return;
            }
            TileEntity tile = WorldUtils.getTileEntity((IBlockReader)player.field_70170_p, message.pos);
            if (tile != null) {
                HashList<QIOFilter<?>> filters;
                int index;
                if (message.filter instanceof SorterFilter && tile instanceof TileEntityLogisticalSorter) {
                    HashList<SorterFilter<?>> filters2 = ((TileEntityLogisticalSorter)tile).getFilters();
                    int index2 = filters2.indexOf(message.filter);
                    if (index2 != -1) {
                        filters2.remove(index2);
                        if (!message.delete) {
                            filters2.add(index2, (SorterFilter)message.edited);
                        }
                    }
                } else if (message.filter instanceof MinerFilter && tile instanceof TileEntityDigitalMiner) {
                    HashList<MinerFilter<?>> filters3 = ((TileEntityDigitalMiner)tile).getFilters();
                    int index3 = filters3.indexOf(message.filter);
                    if (index3 != -1) {
                        filters3.remove(index3);
                        if (!message.delete) {
                            filters3.add(index3, (MinerFilter)message.edited);
                        }
                    }
                } else if (message.filter instanceof TileEntityOredictionificator.OredictionificatorFilter && tile instanceof TileEntityOredictionificator) {
                    HashList<TileEntityOredictionificator.OredictionificatorFilter> filters4 = ((TileEntityOredictionificator)tile).getFilters();
                    int index4 = filters4.indexOf(message.filter);
                    if (index4 != -1) {
                        filters4.remove(index4);
                        if (!message.delete) {
                            filters4.add(index4, (TileEntityOredictionificator.OredictionificatorFilter)message.edited);
                        }
                    }
                } else if (message.filter instanceof QIOFilter && tile instanceof TileEntityQIOFilterHandler && (index = (filters = ((TileEntityQIOFilterHandler)tile).getFilters()).indexOf(message.filter)) != -1) {
                    filters.remove(index);
                    if (!message.delete) {
                        filters.add(index, (QIOFilter)message.edited);
                    }
                }
                tile.func_70296_d();
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketEditFilter pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.writeBoolean(pkt.delete);
        pkt.filter.write(buf);
        if (!pkt.delete) {
            pkt.edited.write(buf);
        }
    }

    public static PacketEditFilter decode(PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        IFilter<?> edited = null;
        boolean delete = buf.readBoolean();
        IFilter<?> filter = BaseFilter.readFromPacket(buf);
        if (!delete) {
            edited = BaseFilter.readFromPacket(buf);
        }
        return new PacketEditFilter(pos, delete, filter, edited);
    }
}

