/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import mekanism.common.inventory.container.item.FrequencyItemContainer;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketFrequencyItemGuiUpdate<FREQ extends Frequency> {
    private final List<FREQ> publicCache;
    private final List<FREQ> privateCache;
    private final FrequencyType<FREQ> frequencyType;
    private final FREQ frequency;
    private final Hand currentHand;

    private PacketFrequencyItemGuiUpdate(Hand hand, FrequencyType<FREQ> type, FREQ freq, List<FREQ> publicFreqs, List<FREQ> privateFreqs) {
        this.currentHand = hand;
        this.frequencyType = type;
        this.frequency = freq;
        this.publicCache = publicFreqs;
        this.privateCache = privateFreqs;
    }

    public static <FREQ extends Frequency> PacketFrequencyItemGuiUpdate<FREQ> update(Hand hand, FrequencyType<FREQ> type, UUID ownerUUID, FREQ freq) {
        return new PacketFrequencyItemGuiUpdate<FREQ>(hand, type, freq, new ArrayList<FREQ>(type.getManager(null).getFrequencies()), new ArrayList<FREQ>(type.getManager(ownerUUID).getFrequencies()));
    }

    public static <FREQ extends Frequency> void handle(PacketFrequencyItemGuiUpdate<FREQ> message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && player.field_71070_bA instanceof FrequencyItemContainer) {
                FrequencyItemContainer container = (FrequencyItemContainer)player.field_71070_bA;
                container.handleCacheUpdate(message.publicCache, message.privateCache, message.frequency);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static <FREQ extends Frequency> void encode(PacketFrequencyItemGuiUpdate<FREQ> pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.currentHand);
        pkt.frequencyType.write(buf);
        if (pkt.frequency == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            ((Frequency)pkt.frequency).write(buf);
        }
        buf.func_150787_b(pkt.publicCache.size());
        for (Frequency freq : pkt.publicCache) {
            freq.write(buf);
        }
        buf.func_150787_b(pkt.privateCache.size());
        for (Frequency freq : pkt.privateCache) {
            freq.write(buf);
        }
    }

    public static <FREQ extends Frequency> PacketFrequencyItemGuiUpdate<FREQ> decode(PacketBuffer buf) {
        int i;
        Hand currentHand = (Hand)buf.func_179257_a(Hand.class);
        FrequencyType type = FrequencyType.load(buf);
        ArrayList publicCache = new ArrayList();
        ArrayList privateCache = new ArrayList();
        FREQ frequency = null;
        if (buf.readBoolean()) {
            frequency = Frequency.readFromPacket(buf);
        }
        int amount = buf.func_150792_a();
        for (i = 0; i < amount; ++i) {
            publicCache.add(Frequency.readFromPacket(buf));
        }
        amount = buf.func_150792_a();
        for (i = 0; i < amount; ++i) {
            privateCache.add(Frequency.readFromPacket(buf));
        }
        return new PacketFrequencyItemGuiUpdate<Object>(currentHand, type, frequency, publicCache, privateCache);
    }
}

