/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.lib.radiation.RadiationManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRadiationData {
    private final RadiationPacketType type;
    private RadiationManager.RadiationScale scale;
    private double radiation;

    private PacketRadiationData(RadiationManager.RadiationScale scale) {
        this.type = RadiationPacketType.SCALE;
        this.scale = scale;
    }

    private PacketRadiationData(double radiation) {
        this.type = RadiationPacketType.PLAYER;
        this.radiation = radiation;
    }

    public static PacketRadiationData create(RadiationManager.RadiationScale scale) {
        return new PacketRadiationData(scale);
    }

    public static void sync(ServerPlayerEntity player) {
        player.getCapability(Capabilities.RADIATION_ENTITY_CAPABILITY).ifPresent(c -> Mekanism.packetHandler.sendTo(new PacketRadiationData(c.getRadiation()), player));
    }

    public static void handle(PacketRadiationData message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ClientPlayerEntity player;
            if (message.type == RadiationPacketType.SCALE) {
                Mekanism.radiationManager.setClientScale(message.scale);
            } else if (message.type == RadiationPacketType.PLAYER && (player = Minecraft.func_71410_x().field_71439_g) != null) {
                player.getCapability(Capabilities.RADIATION_ENTITY_CAPABILITY).ifPresent(c -> c.set(message.radiation));
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketRadiationData pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.type);
        if (pkt.type == RadiationPacketType.SCALE) {
            buf.func_179249_a((Enum)pkt.scale);
        } else if (pkt.type == RadiationPacketType.PLAYER) {
            buf.writeDouble(pkt.radiation);
        }
    }

    public static PacketRadiationData decode(PacketBuffer buf) {
        RadiationPacketType type = (RadiationPacketType)buf.func_179257_a(RadiationPacketType.class);
        if (type == RadiationPacketType.SCALE) {
            return new PacketRadiationData((RadiationManager.RadiationScale)buf.func_179257_a(RadiationManager.RadiationScale.class));
        }
        if (type == RadiationPacketType.PLAYER) {
            return new PacketRadiationData(buf.readDouble());
        }
        return null;
    }

    public static enum RadiationPacketType {
        SCALE,
        PLAYER;

    }
}

