/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.common.entity.EntityRobit;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRobit {
    private final RobitPacketType activeType;
    private final int entityId;
    private ITextComponent name;

    public PacketRobit(RobitPacketType type, int entityId) {
        this.activeType = type;
        this.entityId = entityId;
    }

    public PacketRobit(int entityId, @Nonnull ITextComponent name) {
        this.activeType = RobitPacketType.NAME;
        this.entityId = entityId;
        this.name = name;
    }

    public static void handle(PacketRobit message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            EntityRobit robit;
            ServerPlayerEntity player = ctx.getSender();
            if (player != null && (robit = (EntityRobit)player.field_70170_p.func_73045_a(message.entityId)) != null) {
                if (message.activeType == RobitPacketType.FOLLOW) {
                    robit.setFollowing(!robit.getFollowing());
                } else if (message.activeType == RobitPacketType.NAME) {
                    robit.func_200203_b(message.name);
                } else if (message.activeType == RobitPacketType.GO_HOME) {
                    robit.goHome();
                } else if (message.activeType == RobitPacketType.DROP_PICKUP) {
                    robit.setDropPickup(!robit.getDropPickup());
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketRobit pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.activeType);
        buf.func_150787_b(pkt.entityId);
        if (pkt.activeType == RobitPacketType.NAME) {
            buf.func_179256_a(pkt.name);
        }
    }

    public static PacketRobit decode(PacketBuffer buf) {
        RobitPacketType activeType = (RobitPacketType)buf.func_179257_a(RobitPacketType.class);
        int entityId = buf.func_150792_a();
        if (activeType == RobitPacketType.NAME) {
            return new PacketRobit(entityId, buf.func_179258_d());
        }
        return new PacketRobit(activeType, entityId);
    }

    public static enum RobitPacketType {
        FOLLOW,
        NAME,
        GO_HOME,
        DROP_PICKUP;

    }
}

