/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.resource;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.resource.IResource;
import mekanism.common.resource.MiscResource;
import mekanism.common.resource.PrimaryResource;
import net.minecraft.util.IStringSerializable;

public enum OreType implements IStringSerializable
{
    COPPER(PrimaryResource.COPPER, 16, 8, 0, 0, 60),
    TIN(PrimaryResource.TIN, 14, 8, 0, 0, 60),
    OSMIUM(PrimaryResource.OSMIUM, 12, 8, 0, 0, 60),
    URANIUM(PrimaryResource.URANIUM, 8, 8, 0, 0, 60),
    FLUORITE(MiscResource.FLUORITE, 6, 12, 0, 0, 32),
    LEAD(PrimaryResource.LEAD, 8, 8, 0, 0, 48);

    public static Codec<OreType> CODEC;
    private static final Map<String, OreType> NAME_LOOKUP;
    private final IResource resource;
    private final int perChunk;
    private final int maxVeinSize;
    private final int bottomOffset;
    private final int topOffset;
    private final int maxHeight;

    private OreType(IResource resource, int perChunk, int maxVeinSize, int bottomOffset, int topOffset, int maxHeight) {
        this.resource = resource;
        this.perChunk = perChunk;
        this.maxVeinSize = maxVeinSize;
        this.bottomOffset = bottomOffset;
        this.topOffset = topOffset;
        this.maxHeight = maxHeight;
    }

    public IResource getResource() {
        return this.resource;
    }

    public int getPerChunk() {
        return this.perChunk;
    }

    public int getMaxVeinSize() {
        return this.maxVeinSize;
    }

    public int getBottomOffset() {
        return this.bottomOffset;
    }

    public int getTopOffset() {
        return this.topOffset;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public static OreType get(IResource resource) {
        for (OreType ore : OreType.values()) {
            if (resource != ore.resource) continue;
            return ore;
        }
        return null;
    }

    @Nonnull
    public String func_176610_l() {
        return this.resource.getRegistrySuffix();
    }

    @Nullable
    private static OreType byName(String name) {
        return NAME_LOOKUP.get(name);
    }

    static {
        CODEC = IStringSerializable.func_233023_a_(OreType::values, OreType::byName);
        NAME_LOOKUP = Arrays.stream(OreType.values()).collect(Collectors.toMap(OreType::func_176610_l, oreType -> oreType));
    }
}

