/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.AutomationType;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.SecurityUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;

public class TileEntityPersonalChest
extends TileEntityMekanism {
    public float lidAngle;
    public float prevLidAngle;

    public TileEntityPersonalChest() {
        super(MekanismBlocks.PERSONAL_CHEST);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInteract = (stack, automationType) -> automationType == AutomationType.MANUAL || SecurityUtils.getSecurity(this, Dist.DEDICATED_SERVER) == SecurityMode.PUBLIC;
        for (int slotY = 0; slotY < 6; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                builder.addSlot(BasicInventorySlot.at(canInteract, canInteract, (IContentsListener)this, 8 + slotX * 18, 26 + slotY * 18));
            }
        }
        return builder.build();
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        this.updateLidAngle();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.updateLidAngle();
    }

    private void updateLidAngle() {
        this.prevLidAngle = this.lidAngle;
        float increment = 0.1f;
        if (!this.playersUsing.isEmpty() && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184148_a(null, (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)this.func_174877_v().func_177956_o() + 0.5, (double)((float)this.func_174877_v().func_177952_p() + 0.5f), SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.playersUsing.isEmpty() && this.lidAngle > 0.0f || !this.playersUsing.isEmpty() && this.lidAngle < 1.0f) {
            float split;
            float angle = this.lidAngle;
            this.lidAngle = this.playersUsing.isEmpty() ? (this.lidAngle -= increment) : (this.lidAngle += increment);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (split = 0.5f) && angle >= split) {
                this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }
}

