/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackGasToItemStackCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.factory.TileEntityItemToItemFactory;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.upgrade.AdvancedMachineUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityItemStackGasToItemStackFactory
extends TileEntityItemToItemFactory<ItemStackGasToItemStackRecipe>
implements IHasDumpButton {
    private final ILongInputHandler<@NonNull GasStack> gasInputHandler;
    private double secondaryEnergyPerTick;
    private long secondaryEnergyThisTick;
    private GasInventorySlot extraSlot;
    private IGasTank gasTank;

    public TileEntityItemStackGasToItemStackFactory(IBlockProvider blockProvider) {
        super(blockProvider);
        this.gasInputHandler = InputHelper.getInputHandler(this.gasTank);
        this.configComponent.addSupported(TransmissionType.GAS);
        this.configComponent.setupInputConfig(TransmissionType.GAS, this.gasTank);
        this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick();
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.gasTank = ChemicalTankBuilder.GAS.input(210L * (long)this.tier.processes, gas -> this.containsRecipe(recipe -> ((GasStackIngredient)recipe.getChemicalInput()).testType(gas)), this);
        builder.addTank(this.gasTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder) {
        super.addSlots(builder);
        this.extraSlot = GasInventorySlot.fillOrConvert(this.gasTank, () -> ((TileEntityItemStackGasToItemStackFactory)this).func_145831_w(), this, 7, 57);
        builder.addSlot(this.extraSlot);
    }

    public IGasTank getGasTank() {
        return this.gasTank;
    }

    @Override
    @Nullable
    protected GasInventorySlot getExtraSlot() {
        return this.extraSlot;
    }

    @Override
    public boolean isValidInputItem(@Nonnull ItemStack stack) {
        return this.containsRecipe(recipe -> recipe.getItemInput().testType(stack));
    }

    @Override
    public boolean inputProducesOutput(int process, @Nonnull ItemStack fallbackInput, @Nonnull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot, boolean updateCache) {
        ItemStack output;
        Gas gas;
        ItemStackGasToItemStackRecipe cachedRecipe;
        if (outputSlot.isEmpty()) {
            return true;
        }
        CachedRecipe cached = this.getCachedRecipe(process);
        if (cached != null && (cachedRecipe = (ItemStackGasToItemStackRecipe)cached.getRecipe()).getItemInput().testType(fallbackInput) && (this.gasTank.isEmpty() || ((GasStackIngredient)cachedRecipe.getChemicalInput()).testType(this.gasTank.getType()))) {
            return true;
        }
        GasStack gasStack = (GasStack)this.gasTank.getStack();
        ItemStackGasToItemStackRecipe foundRecipe = (ItemStackGasToItemStackRecipe)this.findFirstRecipe(arg_0 -> TileEntityItemStackGasToItemStackFactory.lambda$inputProducesOutput$3(fallbackInput, gasStack, gas = (Gas)gasStack.getType(), output = outputSlot.getStack(), arg_0));
        if (foundRecipe == null) {
            return false;
        }
        if (updateCache) {
            CachedRecipe<ItemStackGasToItemStackRecipe> newCachedRecipe = this.createNewCachedRecipe(foundRecipe, process);
            if (newCachedRecipe == null) {
                return false;
            }
            this.updateCachedRecipe(newCachedRecipe, process);
        }
        return true;
    }

    @Override
    protected void handleSecondaryFuel() {
        this.extraSlot.fillTankOrConvert();
        this.secondaryEnergyThisTick = this.getSupportedUpgrade().contains(Upgrade.GAS) ? (long)StatUtils.inversePoisson(this.secondaryEnergyPerTick) : MathUtils.clampToLong(Math.ceil(this.secondaryEnergyPerTick));
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ItemStackGasToItemStackRecipe> getRecipeType() {
        switch (this.field_200663_e) {
            case INJECTING: {
                return MekanismRecipeType.INJECTING;
            }
            case PURIFYING: {
                return MekanismRecipeType.PURIFYING;
            }
        }
        return MekanismRecipeType.COMPRESSING;
    }

    @Override
    @Nullable
    public ItemStackGasToItemStackRecipe getRecipe(int cacheIndex) {
        ItemStack stack = (ItemStack)this.inputHandlers[cacheIndex].getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        GasStack gasStack = (GasStack)this.gasInputHandler.getInput();
        if (gasStack.isEmpty()) {
            return null;
        }
        return (ItemStackGasToItemStackRecipe)this.findFirstRecipe(recipe -> recipe.test(stack, gasStack));
    }

    @Override
    public CachedRecipe<ItemStackGasToItemStackRecipe> createNewCachedRecipe(@Nonnull ItemStackGasToItemStackRecipe recipe, int cacheIndex) {
        return new ItemStackGasToItemStackCachedRecipe<ItemStackGasToItemStackRecipe>(recipe, (IInputHandler<ItemStack>)this.inputHandlers[cacheIndex], this.gasInputHandler, () -> this.secondaryEnergyThisTick, (IOutputHandler<ItemStack>)this.outputHandlers[cacheIndex]).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED || upgrade == Upgrade.GAS && this.getSupportedUpgrade().contains(Upgrade.GAS)) {
            this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick();
        }
    }

    public double getSecondaryEnergyPerTick() {
        return MekanismUtils.getGasPerTickMean(this, 1L);
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof AdvancedMachineUpgradeData) {
            int i;
            AdvancedMachineUpgradeData data = (AdvancedMachineUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.gasTank.setStack(data.stored);
            this.extraSlot.setStack(data.gasSlot.getStack());
            this.energySlot.setStack(data.energySlot.getStack());
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                ((IInventorySlot)this.inputSlots.get(i)).setStack(((IInventorySlot)data.inputSlots.get(i)).getStack());
            }
            for (i = 0; i < data.outputSlots.size(); ++i) {
                ((IInventorySlot)this.outputSlots.get(i)).setStack(((IInventorySlot)data.outputSlots.get(i)).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public AdvancedMachineUpgradeData getUpgradeData() {
        return new AdvancedMachineUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, (GasStack)this.gasTank.getStack(), this.extraSlot, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    @Override
    public void dump() {
        this.gasTank.setEmpty();
    }

    private static /* synthetic */ boolean lambda$inputProducesOutput$3(ItemStack fallbackInput, GasStack gasStack, Gas gas, ItemStack output, ItemStackGasToItemStackRecipe recipe) {
        if (recipe.getItemInput().testType(fallbackInput) && (gasStack.isEmpty() || ((GasStackIngredient)recipe.getChemicalInput()).testType(gas))) {
            return ItemHandlerHelper.canItemStacksStack((ItemStack)recipe.getOutput(fallbackInput, gasStack), (ItemStack)output);
        }
        return false;
    }
}

