/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.MetallurgicInfuserCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.chemical.InfusionInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.factory.TileEntityItemToItemFactory;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.upgrade.MetallurgicInfuserUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityMetallurgicInfuserFactory
extends TileEntityItemToItemFactory<MetallurgicInfuserRecipe>
implements IHasDumpButton {
    private final IInputHandler<@NonNull InfusionStack> infusionInputHandler;
    private InfusionInventorySlot extraSlot;
    private IInfusionTank infusionTank;

    public TileEntityMetallurgicInfuserFactory(IBlockProvider blockProvider) {
        super(blockProvider);
        this.infusionInputHandler = InputHelper.getInputHandler(this.infusionTank);
        this.configComponent.addSupported(TransmissionType.INFUSION);
        this.configComponent.setupIOConfig(TransmissionType.INFUSION, this.infusionTank, this.infusionTank, RelativeSide.RIGHT).setCanEject(false);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> getInitialInfusionTanks() {
        ChemicalTankHelper<InfuseType, InfusionStack, IInfusionTank> builder = ChemicalTankHelper.forSideInfusionWithConfig(this::getDirection, this::getConfig);
        this.infusionTank = ChemicalTankBuilder.INFUSION.create(1000L * (long)this.tier.processes, type -> this.containsRecipe(recipe -> recipe.getInfusionInput().testType(type)), this);
        builder.addTank(this.infusionTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder) {
        super.addSlots(builder);
        this.extraSlot = InfusionInventorySlot.fillOrConvert(this.infusionTank, () -> ((TileEntityMetallurgicInfuserFactory)this).func_145831_w(), this, 7, 57);
        builder.addSlot(this.extraSlot);
    }

    public IInfusionTank getInfusionTank() {
        return this.infusionTank;
    }

    @Override
    @Nullable
    protected InfusionInventorySlot getExtraSlot() {
        return this.extraSlot;
    }

    @Override
    public boolean isValidInputItem(@Nonnull ItemStack stack) {
        return this.containsRecipe(recipe -> recipe.getItemInput().testType(stack));
    }

    @Override
    public boolean inputProducesOutput(int process, @Nonnull ItemStack fallbackInput, @Nonnull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot, boolean updateCache) {
        ItemStack output;
        InfuseType type;
        MetallurgicInfuserRecipe cachedRecipe;
        if (outputSlot.isEmpty()) {
            return true;
        }
        CachedRecipe cached = this.getCachedRecipe(process);
        if (cached != null && (cachedRecipe = (MetallurgicInfuserRecipe)cached.getRecipe()).getItemInput().testType(fallbackInput) && (this.infusionTank.isEmpty() || cachedRecipe.getInfusionInput().testType(this.infusionTank.getType()))) {
            return true;
        }
        long stored = this.infusionTank.getStored();
        MetallurgicInfuserRecipe foundRecipe = (MetallurgicInfuserRecipe)this.findFirstRecipe(arg_0 -> this.lambda$inputProducesOutput$3(stored, type = (InfuseType)this.infusionTank.getType(), fallbackInput, output = outputSlot.getStack(), arg_0));
        if (foundRecipe == null) {
            return false;
        }
        if (updateCache) {
            CachedRecipe<MetallurgicInfuserRecipe> newCachedRecipe = this.createNewCachedRecipe(foundRecipe, process);
            if (newCachedRecipe == null) {
                return false;
            }
            this.updateCachedRecipe(newCachedRecipe, process);
        }
        return true;
    }

    @Override
    protected void handleSecondaryFuel() {
        this.extraSlot.fillTankOrConvert();
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @Override
    @Nonnull
    public MekanismRecipeType<MetallurgicInfuserRecipe> getRecipeType() {
        return MekanismRecipeType.METALLURGIC_INFUSING;
    }

    @Override
    @Nullable
    public MetallurgicInfuserRecipe getRecipe(int cacheIndex) {
        ItemStack stack = (ItemStack)this.inputHandlers[cacheIndex].getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        InfusionStack infusionStack = this.infusionInputHandler.getInput();
        if (infusionStack.isEmpty()) {
            return null;
        }
        return (MetallurgicInfuserRecipe)this.findFirstRecipe(recipe -> recipe.test(infusionStack, stack));
    }

    @Override
    public CachedRecipe<MetallurgicInfuserRecipe> createNewCachedRecipe(@Nonnull MetallurgicInfuserRecipe recipe, int cacheIndex) {
        return new MetallurgicInfuserCachedRecipe(recipe, this.infusionInputHandler, this.inputHandlers[cacheIndex], this.outputHandlers[cacheIndex]).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof MetallurgicInfuserUpgradeData) {
            int i;
            MetallurgicInfuserUpgradeData data = (MetallurgicInfuserUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.infusionTank.setStack(data.stored);
            this.extraSlot.setStack(data.infusionSlot.getStack());
            this.energySlot.setStack(data.energySlot.getStack());
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                ((IInventorySlot)this.inputSlots.get(i)).setStack(((IInventorySlot)data.inputSlots.get(i)).getStack());
            }
            for (i = 0; i < data.outputSlots.size(); ++i) {
                ((IInventorySlot)this.outputSlots.get(i)).setStack(((IInventorySlot)data.outputSlots.get(i)).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public MetallurgicInfuserUpgradeData getUpgradeData() {
        return new MetallurgicInfuserUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, (InfusionStack)this.infusionTank.getStack(), this.extraSlot, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    @Override
    public void dump() {
        this.infusionTank.setEmpty();
    }

    private /* synthetic */ boolean lambda$inputProducesOutput$3(long stored, InfuseType type, ItemStack fallbackInput, ItemStack output, MetallurgicInfuserRecipe recipe) {
        if (stored == 0L || recipe.getInfusionInput().testType(type)) {
            return recipe.getItemInput().testType(fallbackInput) && ItemHandlerHelper.canItemStacksStack((ItemStack)recipe.getOutput((InfusionStack)this.infusionTank.getStack(), fallbackInput), (ItemStack)output);
        }
        return false;
    }
}

