/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.MetallurgicInfuserCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.InfusionInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.upgrade.MetallurgicInfuserUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;

public class TileEntityMetallurgicInfuser
extends TileEntityProgressMachine<MetallurgicInfuserRecipe>
implements IHasDumpButton {
    public static final long MAX_INFUSE = 1000L;
    public IInfusionTank infusionTank;
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final IInputHandler<@NonNull InfusionStack> infusionInputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private MachineEnergyContainer<TileEntityMetallurgicInfuser> energyContainer;
    private InfusionInventorySlot infusionSlot;
    private InputInventorySlot inputSlot;
    private OutputInventorySlot outputSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityMetallurgicInfuser() {
        super(MekanismBlocks.METALLURGIC_INFUSER, 200);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.INFUSION);
        this.configComponent.setupItemIOExtraConfig(this.inputSlot, this.outputSlot, this.infusionSlot, this.energySlot);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.configComponent.setupIOConfig(TransmissionType.INFUSION, this.infusionTank, this.infusionTank, RelativeSide.RIGHT).setCanEject(false);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM);
        this.infusionInputHandler = InputHelper.getInputHandler(this.infusionTank);
        this.itemInputHandler = InputHelper.getInputHandler(this.inputSlot);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputSlot);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> getInitialInfusionTanks() {
        ChemicalTankHelper<InfuseType, InfusionStack, IInfusionTank> builder = ChemicalTankHelper.forSideInfusionWithConfig(this::getDirection, this::getConfig);
        this.infusionTank = ChemicalTankBuilder.INFUSION.create(1000L, ChemicalTankBuilder.INFUSION.alwaysTrueBi, (type, automationType) -> {
            if (!this.inputSlot.isEmpty()) {
                ItemStack stack = this.inputSlot.getStack();
                return this.containsRecipe(recipe -> recipe.getItemInput().testType(stack) && recipe.getInfusionInput().testType(type));
            }
            return true;
        }, type -> this.containsRecipe(recipe -> recipe.getInfusionInput().testType(type)), (IContentsListener)this);
        builder.addTank(this.infusionTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.infusionSlot = InfusionInventorySlot.fillOrConvert(this.infusionTank, () -> ((TileEntityMetallurgicInfuser)this).func_145831_w(), this, 17, 35);
        builder.addSlot(this.infusionSlot);
        this.inputSlot = InputInventorySlot.at(stack -> {
            if (!this.infusionTank.isEmpty()) {
                return this.containsRecipe(recipe -> recipe.getInfusionInput().testType(this.infusionTank.getType()) && recipe.getItemInput().testType(stack));
            }
            return true;
        }, stack -> this.containsRecipe(recipe -> recipe.getItemInput().testType(stack)), (IContentsListener)this, 51, 43);
        builder.addSlot(this.inputSlot);
        this.outputSlot = OutputInventorySlot.at(this, 109, 43);
        builder.addSlot(this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityMetallurgicInfuser)this).func_145831_w(), this, 143, 35);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.infusionSlot.fillTankOrConvert();
        this.cachedRecipe = this.getUpdatedCache(0);
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
    }

    @Override
    @Nonnull
    public MekanismRecipeType<MetallurgicInfuserRecipe> getRecipeType() {
        return MekanismRecipeType.METALLURGIC_INFUSING;
    }

    @Override
    @Nullable
    public MetallurgicInfuserRecipe getRecipe(int cacheIndex) {
        ItemStack stack = this.itemInputHandler.getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        InfusionStack infusionStack = this.infusionInputHandler.getInput();
        if (infusionStack.isEmpty()) {
            return null;
        }
        return (MetallurgicInfuserRecipe)this.findFirstRecipe(recipe -> recipe.test(infusionStack, stack));
    }

    @Override
    @Nullable
    public CachedRecipe<MetallurgicInfuserRecipe> createNewCachedRecipe(@Nonnull MetallurgicInfuserRecipe recipe, int cacheIndex) {
        return new MetallurgicInfuserCachedRecipe(recipe, this.infusionInputHandler, this.itemInputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(this::setOperatingTicks);
    }

    @Override
    @Nonnull
    public MetallurgicInfuserUpgradeData getUpgradeData() {
        return new MetallurgicInfuserUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.getOperatingTicks(), (InfusionStack)this.infusionTank.getStack(), this.infusionSlot, this.energySlot, this.inputSlot, this.outputSlot, this.getComponents());
    }

    public MachineEnergyContainer<TileEntityMetallurgicInfuser> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void dump() {
        this.infusionTank.setEmpty();
    }
}

