/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.PressurizedReactionCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.PRCEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityPressurizedReactionChamber
extends TileEntityProgressMachine<PressurizedReactionRecipe> {
    private static final int BASE_DURATION = 100;
    private static final long MAX_GAS = 10000L;
    public BasicFluidTank inputFluidTank;
    public IGasTank inputGasTank;
    public IGasTank outputGasTank;
    private final IOutputHandler<@NonNull Pair<@NonNull ItemStack, @NonNull GasStack>> outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NonNull GasStack> gasInputHandler;
    private PRCEnergyContainer energyContainer;
    private InputInventorySlot inputSlot;
    private OutputInventorySlot outputSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityPressurizedReactionChamber() {
        super(MekanismBlocks.PRESSURIZED_REACTION_CHAMBER, 100);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.FLUID, TransmissionType.GAS);
        this.configComponent.setupItemIOConfig(this.inputSlot, this.outputSlot, this.energySlot);
        this.configComponent.setupInputConfig(TransmissionType.FLUID, this.inputFluidTank);
        this.configComponent.setupIOConfig(TransmissionType.GAS, this.inputGasTank, this.outputGasTank, RelativeSide.RIGHT).setEjecting(true);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM, TransmissionType.GAS);
        this.itemInputHandler = InputHelper.getInputHandler(this.inputSlot);
        this.fluidInputHandler = InputHelper.getInputHandler(this.inputFluidTank);
        this.gasInputHandler = InputHelper.getInputHandler(this.inputGasTank);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputGasTank, (IInventorySlot)this.outputSlot);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.inputGasTank = ChemicalTankBuilder.GAS.create(10000L, ChemicalTankBuilder.GAS.notExternal, ChemicalTankBuilder.GAS.alwaysTrueBi, gas -> this.containsRecipe(recipe -> recipe.getInputGas().testType(gas)), ChemicalAttributeValidator.ALWAYS_ALLOW, (IContentsListener)this);
        builder.addTank(this.inputGasTank);
        this.outputGasTank = ChemicalTankBuilder.GAS.output(10000L, this);
        builder.addTank(this.outputGasTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.inputFluidTank = BasicFluidTank.input(10000, fluid -> this.containsRecipe(recipe -> recipe.getInputFluid().testType(fluid)), this);
        builder.addTank(this.inputFluidTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = PRCEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipe(recipe -> recipe.getInputSolid().testType(item)), this, 54, 35);
        builder.addSlot(this.inputSlot);
        this.outputSlot = OutputInventorySlot.at(this, 116, 35);
        builder.addSlot(this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityPressurizedReactionChamber)this).func_145831_w(), this, 141, 17);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        CachedRecipe oldCache = this.cachedRecipe;
        this.cachedRecipe = this.getUpdatedCache(0);
        if (oldCache != this.cachedRecipe) {
            int recipeDuration = this.cachedRecipe == null ? 100 : ((PressurizedReactionRecipe)this.cachedRecipe.getRecipe()).getDuration();
            boolean update = this.BASE_TICKS_REQUIRED != recipeDuration;
            this.BASE_TICKS_REQUIRED = recipeDuration;
            if (update) {
                this.recalculateUpgrades(Upgrade.SPEED);
            }
            this.energyContainer.updateEnergyPerTick();
        }
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
    }

    @Override
    @Nonnull
    public MekanismRecipeType<PressurizedReactionRecipe> getRecipeType() {
        return MekanismRecipeType.REACTION;
    }

    @Override
    @Nullable
    public PressurizedReactionRecipe getRecipe(int cacheIndex) {
        ItemStack stack = this.itemInputHandler.getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        FluidStack fluid = this.fluidInputHandler.getInput();
        if (fluid.isEmpty()) {
            return null;
        }
        GasStack gas = this.gasInputHandler.getInput();
        if (gas.isEmpty()) {
            return null;
        }
        return (PressurizedReactionRecipe)this.findFirstRecipe(recipe -> recipe.test(stack, fluid, gas));
    }

    @Override
    @Nullable
    public CachedRecipe<PressurizedReactionRecipe> createNewCachedRecipe(@Nonnull PressurizedReactionRecipe recipe, int cacheIndex) {
        return new PressurizedReactionCachedRecipe(recipe, this.itemInputHandler, this.fluidInputHandler, this.gasInputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(this::setOperatingTicks);
    }

    public PRCEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }
}

