/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.AttributeStateBoilerValveMode;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityBoilerValve
extends TileEntityBoilerCasing {
    public TileEntityBoilerValve() {
        super(MekanismBlocks.BOILER_VALVE);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        return side -> ((BoilerMultiblockData)this.getMultiblock()).getGasTanks(side);
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        return side -> ((BoilerMultiblockData)this.getMultiblock()).getFluidTanks(side);
    }

    @Override
    protected void onUpdateServer(BoilerMultiblockData multiblock) {
        super.onUpdateServer(multiblock);
        if (multiblock.isFormed()) {
            AttributeStateBoilerValveMode.BoilerValveMode mode = this.getMode();
            if (mode == AttributeStateBoilerValveMode.BoilerValveMode.OUTPUT_STEAM) {
                ChemicalUtil.emit(multiblock.getDirectionsToEmit(this.func_174877_v()), multiblock.steamTank, (TileEntity)this);
            } else if (mode == AttributeStateBoilerValveMode.BoilerValveMode.OUTPUT_COOLANT) {
                ChemicalUtil.emit(multiblock.getDirectionsToEmit(this.func_174877_v()), multiblock.cooledCoolantTank, (TileEntity)this);
            }
        }
    }

    @Override
    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.FLUID || type == SubstanceType.GAS) {
            return false;
        }
        return super.persists(type);
    }

    @Override
    public int getRedstoneLevel() {
        return ((BoilerMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    private AttributeStateBoilerValveMode.BoilerValveMode getMode() {
        return (AttributeStateBoilerValveMode.BoilerValveMode)((Object)this.func_195044_w().func_177229_b(AttributeStateBoilerValveMode.modeProperty));
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote()) {
            AttributeStateBoilerValveMode.BoilerValveMode mode = (AttributeStateBoilerValveMode.BoilerValveMode)this.getMode().getNext();
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(AttributeStateBoilerValveMode.modeProperty, (Comparable)((Object)mode)));
            player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.BOILER_VALVE_MODE_CHANGE.translateColored(EnumColor.GRAY, mode)), Util.field_240973_b_);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    @Nonnull
    public FluidStack insertFluid(@Nonnull FluidStack stack, Direction side, @Nonnull Action action) {
        FluidStack ret = super.insertFluid(stack, side, action);
        if (ret.getAmount() < stack.getAmount() && action.execute()) {
            ((BoilerMultiblockData)this.getMultiblock()).triggerValveTransfer(this);
        }
        return ret;
    }

    @Override
    public boolean insertGasCheck(int tank, @Nullable Direction side) {
        if (this.getMode() != AttributeStateBoilerValveMode.BoilerValveMode.INPUT) {
            return false;
        }
        return super.insertGasCheck(tank, side);
    }

    @Override
    public boolean extractGasCheck(int tank, @Nullable Direction side) {
        AttributeStateBoilerValveMode.BoilerValveMode mode = this.getMode();
        if (mode == AttributeStateBoilerValveMode.BoilerValveMode.INPUT || tank == 2 && mode == AttributeStateBoilerValveMode.BoilerValveMode.OUTPUT_STEAM || tank == 0 && mode == AttributeStateBoilerValveMode.BoilerValveMode.OUTPUT_COOLANT) {
            return false;
        }
        return super.extractGasCheck(tank, side);
    }
}

