/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IMekWrench;
import mekanism.api.Upgrade;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.GenericWrench;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.interfaces.IActiveState;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.UpgradeDisplay;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class MekanismUtils {
    public static final Codec<Direction> DIRECTION_CODEC = IStringSerializable.func_233023_a_(Direction::values, Direction::func_176739_a);
    public static final float ONE_OVER_ROOT_TWO = (float)(1.0 / Math.sqrt(2.0));
    public static final Direction[] SIDE_DIRS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static final List<UUID> warnedFails = new ArrayList<UUID>();

    public static void logMismatchedStackSize(long actual, long expected) {
        if (expected != actual) {
            Mekanism.logger.error("Stack size changed by a different amount ({}) than requested ({}).", (Object)actual, (Object)expected, (Object)new Exception());
        }
    }

    public static void logExpectedZero(FloatingLong actual) {
        if (!actual.isZero()) {
            Mekanism.logger.error("Energy value changed by a different amount ({}) than requested (zero).", (Object)actual, (Object)new Exception());
        }
    }

    @Nonnull
    public static String getModId(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        String modid = item.getCreatorModId(stack);
        if (modid == null) {
            ResourceLocation registryName = item.getRegistryName();
            if (registryName == null) {
                Mekanism.logger.error("Unexpected null registry name for item of class type: {}", (Object)item.getClass().getSimpleName());
                return "";
            }
            return registryName.func_110624_b();
        }
        return modid;
    }

    public static boolean isActive(IBlockReader world, BlockPos pos) {
        TileEntity tile = WorldUtils.getTileEntity(world, pos);
        if (tile instanceof IActiveState) {
            return ((IActiveState)tile).getActive();
        }
        return false;
    }

    public static Direction getLeft(Direction orientation) {
        return orientation.func_176746_e();
    }

    public static Direction getRight(Direction orientation) {
        return orientation.func_176735_f();
    }

    public static float fractionUpgrades(IUpgradeTile tile, Upgrade type) {
        if (tile.supportsUpgrades()) {
            return (float)tile.getComponent().getUpgrades(type) / (float)type.getMax();
        }
        return 0.0f;
    }

    public static float getScale(float prevScale, IExtendedFluidTank tank) {
        return MekanismUtils.getScale(prevScale, tank.getFluidAmount(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(float prevScale, IChemicalTank<?, ?> tank) {
        return MekanismUtils.getScale(prevScale, tank.getStored(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(float prevScale, int stored, int capacity, boolean empty) {
        return MekanismUtils.getScale(prevScale, capacity == 0 ? 0.0f : (float)stored / (float)capacity, empty);
    }

    public static float getScale(float prevScale, long stored, long capacity, boolean empty) {
        return MekanismUtils.getScale(prevScale, capacity == 0L ? 0.0f : (float)((double)stored / (double)capacity), empty);
    }

    public static float getScale(float prevScale, IEnergyContainer container) {
        float targetScale;
        FloatingLong maxEnergy = container.getMaxEnergy();
        if (maxEnergy.isZero()) {
            targetScale = 0.0f;
        } else {
            FloatingLong scale = container.getEnergy().divide(maxEnergy);
            targetScale = scale.floatValue();
        }
        return MekanismUtils.getScale(prevScale, targetScale, container.isEmpty());
    }

    public static float getScale(float prevScale, float targetScale, boolean empty) {
        if ((double)Math.abs(prevScale - targetScale) > 0.01) {
            return (9.0f * prevScale + targetScale) / 10.0f;
        }
        if (!empty && prevScale == 0.0f) {
            return targetScale;
        }
        if (empty && (double)prevScale < 0.01) {
            return 0.0f;
        }
        return prevScale;
    }

    public static int getTicks(IUpgradeTile tile, int def) {
        if (tile.supportsUpgrades()) {
            return (int)((double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), -MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED)));
        }
        return def;
    }

    public static FloatingLong getEnergyPerTick(IUpgradeTile tile, FloatingLong def) {
        if (tile.supportsUpgrades()) {
            return def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0f * MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(tile, Upgrade.ENERGY)));
        }
        return def;
    }

    public static double getGasPerTickMean(IUpgradeTile tile, long def) {
        if (tile.supportsUpgrades()) {
            if (tile.getComponent().supports(Upgrade.GAS)) {
                return (double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0f * MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED) - MekanismUtils.fractionUpgrades(tile, Upgrade.GAS));
            }
            return (double)def * Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(tile, Upgrade.SPEED));
        }
        return def;
    }

    public static FloatingLong getMaxEnergy(IUpgradeTile tile, FloatingLong def) {
        if (tile.supportsUpgrades()) {
            return def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), MekanismUtils.fractionUpgrades(tile, Upgrade.ENERGY)));
        }
        return def;
    }

    public static FloatingLong getMaxEnergy(ItemStack stack, FloatingLong def) {
        Map<Upgrade, Integer> upgrades;
        float numUpgrades = 0.0f;
        if (ItemDataUtils.hasData(stack, "componentUpgrade", 10) && (upgrades = Upgrade.buildMap(ItemDataUtils.getCompound(stack, "componentUpgrade"))).containsKey(Upgrade.ENERGY)) {
            numUpgrades = upgrades.get(Upgrade.ENERGY).intValue();
        }
        return def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), numUpgrades / (float)Upgrade.ENERGY.getMax()));
    }

    public static ResourceLocation getResource(ResourceType type, String name) {
        return Mekanism.rl(type.getPrefix() + name);
    }

    public static boolean canFunction(TileEntity tile) {
        if (!(tile instanceof IRedstoneControl)) {
            return true;
        }
        IRedstoneControl control = (IRedstoneControl)tile;
        switch (control.getControlType()) {
            case DISABLED: {
                return true;
            }
            case HIGH: {
                return control.isPowered();
            }
            case LOW: {
                return !control.isPowered();
            }
            case PULSE: {
                return control.isPowered() && !control.wasPowered();
            }
        }
        return false;
    }

    public static BlockRayTraceResult rayTrace(PlayerEntity player) {
        return MekanismUtils.rayTrace(player, RayTraceContext.FluidMode.NONE);
    }

    public static BlockRayTraceResult rayTrace(PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        return MekanismUtils.rayTrace(player, player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e(), fluidMode);
    }

    public static BlockRayTraceResult rayTrace(PlayerEntity player, double reach) {
        return MekanismUtils.rayTrace(player, reach, RayTraceContext.FluidMode.NONE);
    }

    public static BlockRayTraceResult rayTrace(PlayerEntity player, double reach, RayTraceContext.FluidMode fluidMode) {
        Vector3d headVec = MekanismUtils.getHeadVec(player);
        Vector3d lookVec = player.func_70676_i(1.0f);
        Vector3d endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return player.func_130014_f_().func_217299_a(new RayTraceContext(headVec, endVec, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }

    private static Vector3d getHeadVec(PlayerEntity player) {
        double posY = player.func_226278_cu_() + (double)player.func_70047_e();
        if (player.func_213453_ef()) {
            posY -= 0.08;
        }
        return new Vector3d(player.func_226277_ct_(), posY, player.func_226281_cx_());
    }

    public static void addUpgradesToTooltip(ItemStack stack, List<ITextComponent> tooltip) {
        if (ItemDataUtils.hasData(stack, "componentUpgrade", 10)) {
            Map<Upgrade, Integer> upgrades = Upgrade.buildMap(ItemDataUtils.getCompound(stack, "componentUpgrade"));
            for (Map.Entry<Upgrade, Integer> entry : upgrades.entrySet()) {
                tooltip.add(UpgradeDisplay.of(entry.getKey(), entry.getValue()).getTextComponent());
            }
        }
    }

    public static ITextComponent getEnergyDisplayShort(FloatingLong energy) {
        switch ((UnitDisplayUtils.EnergyType)MekanismConfig.general.energyUnit.get()) {
            case J: {
                return UnitDisplayUtils.getDisplayShort(energy, UnitDisplayUtils.ElectricUnit.JOULES);
            }
            case FE: {
                return UnitDisplayUtils.getDisplayShort(EnergyCompatUtils.EnergyType.FORGE.convertToAsFloatingLong(energy), UnitDisplayUtils.ElectricUnit.FORGE_ENERGY);
            }
            case EU: {
                return UnitDisplayUtils.getDisplayShort(EnergyCompatUtils.EnergyType.EU.convertToAsFloatingLong(energy), UnitDisplayUtils.ElectricUnit.ELECTRICAL_UNITS);
            }
        }
        return MekanismLang.ERROR.translate(new Object[0]);
    }

    public static FloatingLong convertToJoules(FloatingLong energy) {
        switch ((UnitDisplayUtils.EnergyType)MekanismConfig.general.energyUnit.get()) {
            case FE: {
                return EnergyCompatUtils.EnergyType.FORGE.convertFrom(energy);
            }
            case EU: {
                return EnergyCompatUtils.EnergyType.EU.convertFrom(energy);
            }
        }
        return energy;
    }

    public static FloatingLong convertToDisplay(FloatingLong energy) {
        switch ((UnitDisplayUtils.EnergyType)MekanismConfig.general.energyUnit.get()) {
            case FE: {
                return EnergyCompatUtils.EnergyType.FORGE.convertToAsFloatingLong(energy);
            }
            case EU: {
                return EnergyCompatUtils.EnergyType.EU.convertToAsFloatingLong(energy);
            }
        }
        return energy;
    }

    public static ITextComponent getTemperatureDisplay(double temp, UnitDisplayUtils.TemperatureUnit unit, boolean shift) {
        double tempKelvin = unit.convertToK(temp, true);
        switch ((UnitDisplayUtils.TempType)MekanismConfig.general.tempUnit.get()) {
            case K: {
                return UnitDisplayUtils.getDisplayShort(tempKelvin, UnitDisplayUtils.TemperatureUnit.KELVIN, shift);
            }
            case C: {
                return UnitDisplayUtils.getDisplayShort(tempKelvin, UnitDisplayUtils.TemperatureUnit.CELSIUS, shift);
            }
            case R: {
                return UnitDisplayUtils.getDisplayShort(tempKelvin, UnitDisplayUtils.TemperatureUnit.RANKINE, shift);
            }
            case F: {
                return UnitDisplayUtils.getDisplayShort(tempKelvin, UnitDisplayUtils.TemperatureUnit.FAHRENHEIT, shift);
            }
            case STP: {
                return UnitDisplayUtils.getDisplayShort(tempKelvin, UnitDisplayUtils.TemperatureUnit.AMBIENT, shift);
            }
        }
        return MekanismLang.ERROR.translate(new Object[0]);
    }

    public static CraftingInventory getDummyCraftingInv() {
        Container tempContainer = new Container(ContainerType.field_221518_l, 1){

            public boolean func_75145_c(@Nonnull PlayerEntity player) {
                return false;
            }
        };
        return new CraftingInventory(tempContainer, 3, 3);
    }

    public static ItemStack findRepairRecipe(CraftingInventory inv, World world) {
        NonNullList dmgItems = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        ItemStack leftStack = (ItemStack)dmgItems.get(0);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            if (leftStack.func_190926_b()) {
                leftStack = inv.func_70301_a(i);
                dmgItems.set(0, (Object)leftStack);
                continue;
            }
            dmgItems.set(1, (Object)inv.func_70301_a(i));
            break;
        }
        if (leftStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack rightStack = (ItemStack)dmgItems.get(1);
        if (!rightStack.func_190926_b() && leftStack.func_77973_b() == rightStack.func_77973_b() && leftStack.func_190916_E() == 1 && rightStack.func_190916_E() == 1 && leftStack.func_77973_b().isRepairable(leftStack)) {
            Item theItem = leftStack.func_77973_b();
            int dmgDiff0 = theItem.getMaxDamage(leftStack) - leftStack.func_77952_i();
            int dmgDiff1 = theItem.getMaxDamage(leftStack) - rightStack.func_77952_i();
            int value = dmgDiff0 + dmgDiff1 + theItem.getMaxDamage(leftStack) * 5 / 100;
            int solve = Math.max(0, theItem.getMaxDamage(leftStack) - value);
            ItemStack repaired = new ItemStack((IItemProvider)leftStack.func_77973_b());
            repaired.func_196085_b(solve);
            return repaired;
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public static IMekWrench getWrench(ItemStack it) {
        Item item = it.func_77973_b();
        if (item instanceof IMekWrench) {
            return (IMekWrench)item;
        }
        if (item.func_206844_a(MekanismTags.Items.CONFIGURATORS)) {
            return GenericWrench.INSTANCE;
        }
        return null;
    }

    @Nonnull
    public static String getLastKnownUsername(UUID uuid) {
        GameProfile gp;
        String ret = UsernameCache.getLastKnownUsername((UUID)uuid);
        if (ret == null && !warnedFails.contains(uuid) && EffectiveSide.get().isServer() && (gp = ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152652_a(uuid)) != null) {
            ret = gp.getName();
        }
        if (ret == null && !warnedFails.contains(uuid)) {
            Mekanism.logger.warn("Failed to retrieve username for UUID {}, you might want to add it to the JSON cache", (Object)uuid);
            warnedFails.add(uuid);
        }
        return ret != null ? ret : "<???>";
    }

    public static void onChangedPotionEffect(LivingEntity entity, EffectInstance id, boolean reapply) {
        entity.field_70752_e = true;
        if (reapply && !entity.field_70170_p.field_72995_K) {
            Effect effect = id.func_188419_a();
            effect.func_111187_a(entity, entity.func_233645_dx_(), id.func_76458_c());
            effect.func_111185_a(entity, entity.func_233645_dx_(), id.func_76458_c());
        }
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(entity.func_145782_y(), id));
            CriteriaTriggers.field_193139_z.func_193153_a((ServerPlayerEntity)entity);
        }
    }

    @SafeVarargs
    public static ActionResultType performActions(ActionResultType firstAction, Supplier<ActionResultType> ... secondaryActions) {
        if (firstAction == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        ActionResultType result = firstAction;
        boolean hasFailed = result == ActionResultType.FAIL;
        for (Supplier<ActionResultType> secondaryAction : secondaryActions) {
            result = secondaryAction.get();
            if (result == ActionResultType.SUCCESS) {
                return ActionResultType.SUCCESS;
            }
            hasFailed &= result == ActionResultType.FAIL;
        }
        if (hasFailed) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public static int redstoneLevelFromContents(long amount, long capacity) {
        double fractionFull = capacity == 0L ? 0.0 : (double)amount / (double)capacity;
        return MathHelper.func_76141_d((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    public static int redstoneLevelFromContents(FloatingLong amount, FloatingLong capacity) {
        if (capacity.isZero() || amount.isZero()) {
            return 0;
        }
        return 1 + amount.divide(capacity).multiply(14L).intValue();
    }

    public static int redstoneLevelFromContents(List<IInventorySlot> slots) {
        long totalCount = 0L;
        long totalLimit = 0L;
        for (IInventorySlot slot : slots) {
            if (slot.isEmpty()) {
                totalLimit += (long)slot.getLimit(ItemStack.field_190927_a);
                continue;
            }
            totalCount += (long)slot.getCount();
            totalLimit += (long)slot.getLimit(slot.getStack());
        }
        return MekanismUtils.redstoneLevelFromContents(totalCount, totalLimit);
    }

    public static boolean isPlayingMode(PlayerEntity player) {
        return !player.func_184812_l_() && !player.func_175149_v();
    }

    public static enum ResourceType {
        GUI("gui"),
        GUI_BUTTON("gui/button"),
        GUI_BAR("gui/bar"),
        GUI_HUD("gui/hud"),
        GUI_GAUGE("gui/gauge"),
        GUI_PROGRESS("gui/progress"),
        GUI_SLOT("gui/slot"),
        SOUND("sound"),
        RENDER("render"),
        TEXTURE_BLOCKS("textures/block"),
        TEXTURE_ITEMS("textures/item"),
        MODEL("models"),
        INFUSE("infuse"),
        PIGMENT("pigment"),
        SLURRY("slurry");

        private final String prefix;

        private ResourceType(String s) {
            this.prefix = s;
        }

        public String getPrefix() {
            return this.prefix + "/";
        }
    }
}

