/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.IOwnerItem;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.lib.security.ISecurityTile;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.network.PacketSecurityUpdate;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;

public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static boolean isOp(PlayerEntity p) {
        if (p instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)p;
            return MekanismConfig.general.opsBypassRestrictions.get() && player.field_71133_b.func_184103_al().func_152596_g(player.func_146103_bH());
        }
        return false;
    }

    public static boolean canAccess(PlayerEntity player, Object object) {
        ISecurityObject security;
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (!(stack.func_77973_b() instanceof ISecurityItem) && stack.func_77973_b() instanceof IOwnerItem) {
                if (!MekanismConfig.general.allowProtection.get() || SecurityUtils.isOp(player)) {
                    return true;
                }
                UUID owner = ((IOwnerItem)stack.func_77973_b()).getOwnerUUID(stack);
                return owner == null || owner.equals(player.func_110124_au());
            }
            security = SecurityUtils.wrapSecurityItem(stack);
        } else if (object instanceof ISecurityObject) {
            security = (ISecurityObject)object;
        } else {
            return true;
        }
        return !security.hasSecurity() || SecurityUtils.canAccess(security.getSecurityMode(), player, security.getOwnerUUID());
    }

    private static boolean canAccess(SecurityMode mode, PlayerEntity player, UUID owner) {
        if (!MekanismConfig.general.allowProtection.get() || SecurityUtils.isOp(player)) {
            return true;
        }
        if (owner == null || player.func_110124_au().equals(owner)) {
            return true;
        }
        SecurityFrequency freq = SecurityUtils.getFrequency(owner);
        if (freq == null) {
            return true;
        }
        if (freq.isOverridden()) {
            mode = freq.getSecurityMode();
        }
        if (mode == SecurityMode.PUBLIC) {
            return true;
        }
        if (mode == SecurityMode.TRUSTED) {
            return freq.getTrustedUUIDs().contains(player.func_110124_au());
        }
        return false;
    }

    public static SecurityFrequency getFrequency(UUID uuid) {
        return uuid == null ? null : FrequencyType.SECURITY.getManager(null).getFrequency(uuid);
    }

    public static void displayNoAccess(PlayerEntity player) {
        player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, EnumColor.RED, MekanismLang.NO_ACCESS), Util.field_240973_b_);
    }

    public static SecurityMode getSecurity(ISecurityObject security, Dist side) {
        SecurityData data;
        if (!security.hasSecurity()) {
            return SecurityMode.PUBLIC;
        }
        if (side.isDedicatedServer()) {
            SecurityFrequency freq = security instanceof ISecurityTile ? ((ISecurityTile)security).getSecurity().getFrequency() : SecurityUtils.getFrequency(security.getOwnerUUID());
            if (freq != null && freq.isOverridden()) {
                return freq.getSecurityMode();
            }
        } else if (side.isClient() && (data = MekanismClient.clientSecurityMap.get(security.getOwnerUUID())) != null && data.override) {
            return data.mode;
        }
        return security.getSecurityMode();
    }

    public static boolean isOverridden(ISecurityObject security, Dist side) {
        if (!security.hasSecurity() || security.getOwnerUUID() == null) {
            return false;
        }
        if (side.isDedicatedServer()) {
            SecurityFrequency freq = SecurityUtils.getFrequency(security.getOwnerUUID());
            return freq != null && freq.isOverridden();
        }
        SecurityData data = MekanismClient.clientSecurityMap.get(security.getOwnerUUID());
        return data != null && data.override;
    }

    public static void claimItem(PlayerEntity player, ItemStack stack) {
        if (stack.func_77973_b() instanceof IOwnerItem) {
            ((IOwnerItem)stack.func_77973_b()).setOwnerUUID(stack, player.func_110124_au());
            Mekanism.packetHandler.sendToAll(new PacketSecurityUpdate(player.func_110124_au(), null));
            player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, EnumColor.GRAY, MekanismLang.NOW_OWN), Util.field_240973_b_);
        }
    }

    public static void addSecurityTooltip(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip) {
        if (stack.func_77973_b() instanceof IOwnerItem) {
            tooltip.add(OwnerDisplay.of(MekanismClient.tryGetClientPlayer(), ((IOwnerItem)stack.func_77973_b()).getOwnerUUID(stack)).getTextComponent());
        }
        ISecurityObject securityObject = SecurityUtils.wrapSecurityItem(stack);
        tooltip.add((ITextComponent)MekanismLang.SECURITY.translateColored(EnumColor.GRAY, SecurityUtils.getSecurity(securityObject, Dist.CLIENT)));
        if (SecurityUtils.isOverridden(securityObject, Dist.CLIENT)) {
            tooltip.add((ITextComponent)MekanismLang.SECURITY_OVERRIDDEN.translateColored(EnumColor.RED, new Object[0]));
        }
    }

    public static ISecurityObject wrapSecurityItem(final @Nonnull ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISecurityItem)) {
            return ISecurityObject.NO_SECURITY;
        }
        return new ISecurityObject(){

            @Override
            @Nullable
            public UUID getOwnerUUID() {
                return ((ISecurityItem)stack.func_77973_b()).getOwnerUUID(stack);
            }

            @Override
            @Nullable
            public String getOwnerName() {
                UUID ownerUUID = this.getOwnerUUID();
                return ownerUUID == null ? null : MekanismClient.clientUUIDMap.get(ownerUUID);
            }

            @Override
            public SecurityMode getSecurityMode() {
                return ((ISecurityItem)stack.func_77973_b()).getSecurity(stack);
            }

            @Override
            public void setSecurityMode(SecurityMode mode) {
                ((ISecurityItem)stack.func_77973_b()).setSecurity(stack, mode);
            }
        };
    }
}

