/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import java.util.BitSet;
import java.util.Random;
import javax.annotation.Nonnull;
import mekanism.common.world.ResizableOreFeatureConfig;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class ResizableOreFeature
extends Feature<ResizableOreFeatureConfig> {
    public ResizableOreFeature() {
        super(ResizableOreFeatureConfig.CODEC);
    }

    protected Heightmap.Type getHeightmapType() {
        return Heightmap.Type.OCEAN_FLOOR_WG;
    }

    public boolean generate(@Nonnull ISeedReader seedReader, @Nonnull ChunkGenerator chunkGenerator, Random rand, BlockPos pos, ResizableOreFeatureConfig config) {
        float angle = rand.nextFloat() * (float)Math.PI;
        float adjustedSize = (float)config.size.getAsInt() / 8.0f;
        int i = MathHelper.func_76123_f((float)((adjustedSize + 1.0f) / 2.0f));
        float sin = MathHelper.func_76126_a((float)angle) * adjustedSize;
        float cos = MathHelper.func_76134_b((float)angle) * adjustedSize;
        double xMin = (float)pos.func_177958_n() + sin;
        double xMax = (float)pos.func_177958_n() - sin;
        double zMin = (float)pos.func_177952_p() + cos;
        double zMax = (float)pos.func_177952_p() - cos;
        double yMin = pos.func_177956_o() + rand.nextInt(3) - 2;
        double yMax = pos.func_177956_o() + rand.nextInt(3) - 2;
        int minXStart = pos.func_177958_n() - MathHelper.func_76123_f((float)adjustedSize) - i;
        int minYStart = pos.func_177956_o() - 2 - i;
        int minZStart = pos.func_177952_p() - MathHelper.func_76123_f((float)adjustedSize) - i;
        int width = 2 * (MathHelper.func_76123_f((float)adjustedSize) + i);
        int height = 2 * (2 + i);
        for (int l1 = minXStart; l1 <= minXStart + width; ++l1) {
            for (int i2 = minZStart; i2 <= minZStart + width; ++i2) {
                if (minYStart > seedReader.func_201676_a(this.getHeightmapType(), l1, i2)) continue;
                return this.func_207803_a((IWorld)seedReader, rand, config, xMin, xMax, zMin, zMax, yMin, yMax, minXStart, minYStart, minZStart, width, height);
            }
        }
        return false;
    }

    protected boolean func_207803_a(IWorld world, Random random, ResizableOreFeatureConfig config, double xMin, double xMax, double zMin, double zMax, double yMin, double yMax, int minXStart, int minYStart, int minZStart, int width, int height) {
        int i;
        BitSet bitset = new BitSet(width * height * width);
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        int size = config.size.getAsInt();
        double[] adouble = new double[size * 4];
        for (int k = 0; k < size; ++k) {
            float f = (float)k / (float)size;
            int k4 = k * 4;
            adouble[k4] = MathHelper.func_219803_d((double)f, (double)xMin, (double)xMax);
            adouble[k4 + 1] = MathHelper.func_219803_d((double)f, (double)yMin, (double)yMax);
            adouble[k4 + 2] = MathHelper.func_219803_d((double)f, (double)zMin, (double)zMax);
            double d6 = random.nextDouble() * (double)size / 16.0;
            adouble[k4 + 3] = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * f)) + 1.0f) * d6 + 1.0) / 2.0;
        }
        for (i = 0; i < size - 1; ++i) {
            int i4 = i * 4;
            if (!(adouble[i4 + 3] > 0.0)) continue;
            for (int j = i + 1; j < size; ++j) {
                double d3;
                double d2;
                double d1;
                double d4;
                int j4 = j * 4;
                if (!(adouble[j4 + 3] > 0.0) || !((d4 = adouble[i4 + 3] - adouble[j4 + 3]) * d4 > (d1 = adouble[i4] - adouble[j4]) * d1 + (d2 = adouble[i4 + 1] - adouble[j4 + 1]) * d2 + (d3 = adouble[i4 + 2] - adouble[j4 + 2]) * d3)) continue;
                if (d4 > 0.0) {
                    adouble[j4 + 3] = -1.0;
                    continue;
                }
                adouble[i4 + 3] = -1.0;
            }
        }
        i = 0;
        for (int j = 0; j < size; ++j) {
            int j4 = j * 4;
            double d1 = adouble[j4 + 3];
            if (!(d1 >= 0.0)) continue;
            double d2 = adouble[j4];
            double d3 = adouble[j4 + 1];
            double d4 = adouble[j4 + 2];
            int xStart = Math.max(MathHelper.func_76128_c((double)(d2 - d1)), minXStart);
            int yStart = Math.max(MathHelper.func_76128_c((double)(d3 - d1)), minYStart);
            int zStart = Math.max(MathHelper.func_76128_c((double)(d4 - d1)), minZStart);
            int xEnd = Math.max(MathHelper.func_76128_c((double)(d2 + d1)), xStart);
            int yEnd = Math.max(MathHelper.func_76128_c((double)(d3 + d1)), yStart);
            int zEnd = Math.max(MathHelper.func_76128_c((double)(d4 + d1)), zStart);
            for (int x = xStart; x <= xEnd; ++x) {
                double d8 = ((double)x + 0.5 - d2) / d1;
                double d8_squared = d8 * d8;
                if (!(d8_squared < 1.0)) continue;
                for (int y = yStart; y <= yEnd; ++y) {
                    double d9 = ((double)y + 0.5 - d3) / d1;
                    double d9_squared = d9 * d9;
                    if (!(d8_squared + d9_squared < 1.0)) continue;
                    for (int z = zStart; z <= zEnd; ++z) {
                        int l2;
                        double d10 = ((double)z + 0.5 - d4) / d1;
                        if (!(d8_squared + d9_squared + d10 * d10 < 1.0) || bitset.get(l2 = x - minXStart + (y - minYStart) * width + (z - minZStart) * width * height)) continue;
                        bitset.set(l2);
                        mutablePos.func_181079_c(x, y, z);
                        if (!config.target.func_215181_a(world.func_180495_p((BlockPos)mutablePos), random)) continue;
                        world.func_180501_a((BlockPos)mutablePos, config.state, 2);
                        ++i;
                    }
                }
            }
        }
        return i > 0;
    }
}

