/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiBigLight;
import mekanism.client.gui.element.GuiGraph;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiHybridGauge;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.generators.client.gui.element.GuiFissionReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.network.PacketGeneratorsGuiInteract;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class GuiFissionReactor
extends GuiMekanismTile<TileEntityFissionReactorCasing, EmptyTileContainer<TileEntityFissionReactorCasing>> {
    private TranslationButton activateButton;
    private TranslationButton scramButton;
    private GuiGraph heatGraph;

    public GuiFissionReactor(EmptyTileContainer<TileEntityFissionReactorCasing> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_146999_f = 195;
        this.field_147000_g += 6;
        this.field_238743_q_ = 5;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new GuiFissionReactorTab((IGuiWrapper)this, (TileEntityFissionReactorCasing)this.tile, GuiFissionReactorTab.FissionReactorTab.STAT));
        this.func_230480_a_((Widget)new GuiInnerScreen((IGuiWrapper)this, 45, 17, 105, 56, () -> {
            FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock();
            return Arrays.asList(MekanismLang.STATUS.translate(new Object[]{multiblock.isActive() ? EnumColor.BRIGHT_GREEN : EnumColor.RED, BooleanStateDisplay.ActiveDisabled.of((boolean)multiblock.isActive())}), GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{multiblock.lastBurnRate}), GeneratorsLang.FISSION_HEATING_RATE.translate(new Object[]{GuiFissionReactor.formatInt((long)multiblock.lastBoilRate)}), MekanismLang.TEMPERATURE.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getTempColor(), MekanismUtils.getTemperatureDisplay((double)multiblock.heatCapacitor.getTemperature(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), GeneratorsLang.FISSION_DAMAGE.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getDamageColor(), ((TileEntityFissionReactorCasing)this.tile).getDamageString()}));
        }).defaultFormat().spacing(2));
        this.func_230480_a_((Widget)new GuiHybridGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).gasCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).fluidCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getFluidTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 6, 13).setLabel((ITextComponent)GeneratorsLang.FISSION_COOLANT_TANK.translateColored(EnumColor.AQUA, new Object[0])));
        this.func_230480_a_((Widget)new GuiGasGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).fuelTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 25, 13).setLabel((ITextComponent)GeneratorsLang.FISSION_FUEL_TANK.translateColored(EnumColor.DARK_GREEN, new Object[0])));
        this.func_230480_a_((Widget)new GuiGasGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).heatedCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 152, 13).setLabel((ITextComponent)GeneratorsLang.FISSION_HEATED_COOLANT_TANK.translateColored(EnumColor.ORANGE, new Object[0])));
        this.func_230480_a_((Widget)new GuiGasGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).wasteTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 171, 13).setLabel((ITextComponent)GeneratorsLang.FISSION_WASTE_TANK.translateColored(EnumColor.BROWN, new Object[0])));
        this.func_230480_a_((Widget)new GuiHeatTab(() -> {
            ITextComponent environment = MekanismUtils.getTemperatureDisplay((double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).lastEnvironmentLoss, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(new Object[]{environment}));
        }, (IGuiWrapper)this));
        this.activateButton = new TranslationButton((IGuiWrapper)this, this.field_147003_i + 6, this.field_147009_r + 75, 81, 16, (ILangEntry)GeneratorsLang.FISSION_ACTIVATE, () -> MekanismGenerators.packetHandler.sendToServer(new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.FISSION_ACTIVE, (TileEntity)this.tile, 1.0)), null, () -> EnumColor.DARK_GREEN);
        this.func_230480_a_((Widget)this.activateButton);
        this.scramButton = new TranslationButton((IGuiWrapper)this, this.field_147003_i + 89, this.field_147009_r + 75, 81, 16, (ILangEntry)GeneratorsLang.FISSION_SCRAM, () -> MekanismGenerators.packetHandler.sendToServer(new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.FISSION_ACTIVE, (TileEntity)this.tile, 0.0)), null, () -> EnumColor.DARK_RED);
        this.func_230480_a_((Widget)this.scramButton);
        this.func_230480_a_((Widget)new GuiBigLight((IGuiWrapper)this, 173, 76, ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock())::isActive));
        this.func_230480_a_((Widget)new GuiDynamicHorizontalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public ITextComponent getTooltip() {
                return MekanismUtils.getTemperatureDisplay((double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)((GuiFissionReactor)GuiFissionReactor.this).tile).getMultiblock()).heatCapacitor.getTemperature(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true);
            }

            public double getLevel() {
                return Math.min(1.0, ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)((GuiFissionReactor)GuiFissionReactor.this).tile).getMultiblock()).heatCapacitor.getTemperature() / 1800.0);
            }
        }, 5, 104, this.field_146999_f - 12));
        this.heatGraph = new GuiGraph((IGuiWrapper)this, 6, 128, this.field_146999_f - 12, 36, xva$0 -> MekanismLang.TEMPERATURE.translate(new Object[]{xva$0}));
        this.func_230480_a_((Widget)this.heatGraph);
        this.heatGraph.setMinScale(1600L);
        this.updateButtons();
    }

    private void updateButtons() {
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock();
        this.activateButton.field_230693_o_ = !multiblock.isActive();
        this.scramButton.field_230693_o_ = multiblock.isActive();
    }

    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.updateButtons();
        this.drawTitleText(matrix, (ITextComponent)GeneratorsLang.FISSION_REACTOR.translate(new Object[0]), this.field_238743_q_);
        this.drawString(matrix, (ITextComponent)MekanismLang.TEMPERATURE_LONG.translate(new Object[]{""}), 6, 95, this.titleTextColor());
        this.drawString(matrix, (ITextComponent)GeneratorsLang.FISSION_HEAT_GRAPH.translate(new Object[0]), 6, 118, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.heatGraph.addData((long)((int)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).heatCapacitor.getTemperature()));
    }
}

