/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.client.gui.GuiFusionReactorInfo;
import mekanism.generators.client.gui.element.GuiFusionReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiFusionReactorStats
extends GuiFusionReactorInfo {
    private static final NumberFormat nf = NumberFormat.getIntegerInstance();

    public GuiFusionReactorStats(EmptyTileContainer<TileEntityFusionReactorController> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new GuiEnergyTab(() -> {
            FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
            return Arrays.asList(MekanismLang.STORING.translate(new Object[]{EnergyDisplay.of((FloatingLong)multiblock.energyContainer.getEnergy(), (FloatingLong)multiblock.energyContainer.getMaxEnergy())}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{EnergyDisplay.of((FloatingLong)multiblock.getPassiveGeneration(false, true))}));
        }, (IGuiWrapper)this));
        this.func_230480_a_((Widget)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.HEAT));
        this.func_230480_a_((Widget)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.FUEL));
    }

    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitleText(matrix, (ITextComponent)GeneratorsLang.FUSION_REACTOR.translate(new Object[0]), this.field_238743_q_);
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
        if (multiblock.isFormed()) {
            this.drawString(matrix, (ITextComponent)GeneratorsLang.REACTOR_PASSIVE.translateColored(EnumColor.DARK_GREEN, new Object[0]), 6, 26, this.titleTextColor());
            this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.REACTOR_MIN_INJECTION.translate(new Object[]{multiblock.getMinInjectionRate(false)}), 16.0f, 36.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.REACTOR_IGNITION.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getIgnitionTemperature(false), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16.0f, 46.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.REACTOR_MAX_PLASMA.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getMaxPlasmaTemperature(false), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16.0f, 56.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.REACTOR_MAX_CASING.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getMaxCasingTemperature(false), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16.0f, 66.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.REACTOR_PASSIVE_RATE.translate(new Object[]{EnergyDisplay.of((FloatingLong)multiblock.getPassiveGeneration(false, false))}), 16.0f, 76.0f, this.titleTextColor(), 156.0f);
            this.drawString(matrix, (ITextComponent)GeneratorsLang.REACTOR_ACTIVE.translateColored(EnumColor.DARK_BLUE, new Object[0]), 6, 92, this.titleTextColor());
            this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.REACTOR_MIN_INJECTION.translate(new Object[]{multiblock.getMinInjectionRate(true)}), 16.0f, 102.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.REACTOR_IGNITION.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getIgnitionTemperature(true), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16.0f, 112.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.REACTOR_MAX_PLASMA.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getMaxPlasmaTemperature(true), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16.0f, 122.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.REACTOR_MAX_CASING.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getMaxCasingTemperature(true), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), 16.0f, 132.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.REACTOR_PASSIVE_RATE.translate(new Object[]{EnergyDisplay.of((FloatingLong)multiblock.getPassiveGeneration(true, false))}), 16.0f, 142.0f, this.titleTextColor(), 156.0f);
            this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.REACTOR_STEAM_PRODUCTION.translate(new Object[]{nf.format(multiblock.getSteamPerTick(false))}), 16.0f, 152.0f, this.titleTextColor(), 156.0f);
        }
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

