/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.generators.common.registries.GeneratorsFluids;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class RenderBioGenerator
extends MekanismTileEntityRenderer<TileEntityBioGenerator> {
    private static final Map<Direction, Int2ObjectMap<MekanismRenderer.Model3D>> energyDisplays = new EnumMap<Direction, Int2ObjectMap<MekanismRenderer.Model3D>>(Direction.class);
    private static final int stages = 40;

    public static void resetCachedModels() {
        energyDisplays.clear();
    }

    public RenderBioGenerator(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    protected void render(TileEntityBioGenerator tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        if (!tile.bioFuelTank.isEmpty()) {
            matrix.func_227860_a_();
            FluidStack fluid = tile.bioFuelTank.getFluid();
            float fluidScale = (float)fluid.getAmount() / (float)tile.bioFuelTank.getCapacity();
            MekanismRenderer.renderObject((MekanismRenderer.Model3D)this.getModel(tile.getDirection(), (int)(fluidScale * 39.0f)), (MatrixStack)matrix, (IVertexBuilder)renderer.getBuffer(Atlases.func_228785_j_()), (int)MekanismRenderer.getColorARGB((FluidStack)fluid, (float)fluidScale), (int)0xF000F0, (int)overlayLight);
            matrix.func_227865_b_();
        }
    }

    protected String getProfilerSection() {
        return "bioGenerator";
    }

    private MekanismRenderer.Model3D getModel(Direction side, int stage) {
        if (energyDisplays.containsKey(side) && energyDisplays.get(side).containsKey(stage)) {
            return (MekanismRenderer.Model3D)energyDisplays.get(side).get(stage);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(MekanismRenderer.getFluidTexture((FluidStack)GeneratorsFluids.BIOETHANOL.getFluidStack(1), (MekanismRenderer.FluidType)MekanismRenderer.FluidType.STILL));
        switch (side) {
            case NORTH: {
                model.minZ = 0.499;
                model.maxZ = 0.875;
                model.minX = 0.188;
                model.maxX = 0.821;
                break;
            }
            case SOUTH: {
                model.minZ = 0.125;
                model.maxZ = 0.499;
                model.minX = 0.188;
                model.maxX = 0.821;
                break;
            }
            case WEST: {
                model.minX = 0.499;
                model.maxX = 0.875;
                model.minZ = 0.187;
                model.maxZ = 0.821;
                break;
            }
            case EAST: {
                model.minX = 0.125;
                model.maxX = 0.499;
                model.minZ = 0.186;
                model.maxZ = 0.821;
            }
        }
        model.minY = 0.4385;
        model.maxY = 0.4375 + (double)((float)stage / 40.0f) * 0.4375 + 0.001;
        energyDisplays.computeIfAbsent(side, s -> new Int2ObjectOpenHashMap()).putIfAbsent(stage, (Object)model);
        return model;
    }
}

