/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;

public abstract class TileEntityGenerator
extends TileEntityMekanism {
    public FloatingLong output;
    private BasicEnergyContainer energyContainer;

    public TileEntityGenerator(IBlockProvider blockProvider, @Nonnull FloatingLong out) {
        super(blockProvider);
        this.output = out;
    }

    protected RelativeSide getEnergySide() {
        return RelativeSide.FRONT;
    }

    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(() -> ((TileEntityGenerator)this).getDirection());
        this.energyContainer = BasicEnergyContainer.output((FloatingLong)MachineEnergyContainer.validateBlock((TileEntityMekanism)this).getStorage(), (IContentsListener)this);
        builder.addContainer((IEnergyContainer)this.energyContainer, new RelativeSide[]{this.getEnergySide()});
        return builder.build();
    }

    protected void onUpdateServer() {
        if (MekanismUtils.canFunction((TileEntity)this)) {
            CableUtils.emit(EnumSet.of(this.getEnergySide().getDirection(this.getDirection())), (IEnergyContainer)this.energyContainer, (TileEntity)this, (FloatingLong)this.getMaxOutput());
        }
    }

    public int getActiveLightValue() {
        return 8;
    }

    public FloatingLong getMaxOutput() {
        return this.output;
    }

    public boolean renderUpdate() {
        return true;
    }

    public boolean lightUpdate() {
        return true;
    }

    public BasicEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }
}

