/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fission;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.block.attribute.AttributeStateFissionPortMode;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityFissionReactorPort
extends TileEntityFissionReactorCasing
implements IConfigurable {
    public TileEntityFissionReactorPort() {
        super((IBlockProvider)GeneratorsBlocks.FISSION_REACTOR_PORT);
    }

    @Override
    protected void onUpdateServer(FissionReactorMultiblockData multiblock) {
        super.onUpdateServer(multiblock);
        if (multiblock.isFormed()) {
            AttributeStateFissionPortMode.FissionPortMode mode = this.getMode();
            if (mode == AttributeStateFissionPortMode.FissionPortMode.OUTPUT_COOLANT) {
                ChemicalUtil.emit((Set)multiblock.getDirectionsToEmit(this.func_174877_v()), (IChemicalTank)multiblock.heatedCoolantTank, (TileEntity)this);
            } else if (mode == AttributeStateFissionPortMode.FissionPortMode.OUTPUT_WASTE) {
                ChemicalUtil.emit((Set)multiblock.getDirectionsToEmit(this.func_174877_v()), (IChemicalTank)multiblock.wasteTank, (TileEntity)this);
            }
        }
    }

    @Nullable
    public IHeatHandler getAdjacent(Direction side) {
        IHeatHandler handler = super.getAdjacent(side);
        if (handler != null && WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(side)) instanceof TileEntityFissionReactorPort) {
            return null;
        }
        return handler;
    }

    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        return side -> ((FissionReactorMultiblockData)this.getMultiblock()).getGasTanks(side);
    }

    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        return side -> ((FissionReactorMultiblockData)this.getMultiblock()).getFluidTanks(side);
    }

    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        return side -> ((FissionReactorMultiblockData)this.getMultiblock()).getHeatCapacitors(side);
    }

    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.HEAT || type == SubstanceType.GAS || type == SubstanceType.FLUID) {
            return false;
        }
        return super.persists(type);
    }

    private AttributeStateFissionPortMode.FissionPortMode getMode() {
        return (AttributeStateFissionPortMode.FissionPortMode)((Object)this.func_195044_w().func_177229_b(AttributeStateFissionPortMode.modeProperty));
    }

    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote()) {
            AttributeStateFissionPortMode.FissionPortMode mode = (AttributeStateFissionPortMode.FissionPortMode)this.getMode().getNext();
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(AttributeStateFissionPortMode.modeProperty, (Comparable)((Object)mode)));
            player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, new Object[]{MekanismLang.MEKANISM, MekanismLang.BOILER_VALVE_MODE_CHANGE.translateColored(EnumColor.GRAY, new Object[]{mode})}), Util.field_240973_b_);
        }
        return ActionResultType.SUCCESS;
    }

    @Nonnull
    public FluidStack insertFluid(@Nonnull FluidStack stack, Direction side, @Nonnull Action action) {
        FluidStack ret = super.insertFluid(stack, side, action);
        if (ret.getAmount() < stack.getAmount() && action.execute()) {
            ((FissionReactorMultiblockData)this.getMultiblock()).triggerValveTransfer((IMultiblock)this);
        }
        return ret;
    }

    public boolean insertGasCheck(int tank, @Nullable Direction side) {
        if (this.getMode() != AttributeStateFissionPortMode.FissionPortMode.INPUT) {
            return false;
        }
        return super.insertGasCheck(tank, side);
    }

    public boolean extractGasCheck(int tank, @Nullable Direction side) {
        AttributeStateFissionPortMode.FissionPortMode mode = this.getMode();
        if (mode == AttributeStateFissionPortMode.FissionPortMode.INPUT || tank == 2 && mode == AttributeStateFissionPortMode.FissionPortMode.OUTPUT_COOLANT || tank == 1 && mode == AttributeStateFissionPortMode.FissionPortMode.OUTPUT_WASTE) {
            return false;
        }
        return super.extractGasCheck(tank, side);
    }

    public int getRedstoneLevel() {
        return ((FissionReactorMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }
}

