/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.bar.GuiVerticalRateBar;
import mekanism.client.gui.element.button.GuiGasMode;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.client.gui.element.GuiTurbineTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiIndustrialTurbine
extends GuiMekanismTile<TileEntityTurbineCasing, MekanismTileContainer<TileEntityTurbineCasing>> {
    public GuiIndustrialTurbine(MekanismTileContainer<TileEntityTurbineCasing> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_238745_s_ += 2;
        this.dynamicSlots = true;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new GuiInnerScreen((IGuiWrapper)this, 50, 18, 112, 50, () -> {
            ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
            TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock();
            if (multiblock.isFormed()) {
                FloatingLong energyMultiplier = ((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply((long)Math.min(multiblock.blades, multiblock.coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
                double rate = (double)multiblock.lowerVolume * ((double)multiblock.clientDispersers * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get());
                rate = Math.min(rate, (double)multiblock.vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
                list.add(GeneratorsLang.TURBINE_PRODUCTION_AMOUNT.translate(new Object[]{EnergyDisplay.of((FloatingLong)energyMultiplier.multiply(multiblock.clientFlow))}));
                list.add(GeneratorsLang.TURBINE_FLOW_RATE.translate(new Object[]{GuiIndustrialTurbine.formatInt((long)multiblock.clientFlow)}));
                list.add(GeneratorsLang.TURBINE_CAPACITY.translate(new Object[]{GuiIndustrialTurbine.formatInt((long)multiblock.getSteamCapacity())}));
                list.add(GeneratorsLang.TURBINE_MAX_FLOW.translate(new Object[]{GuiIndustrialTurbine.formatInt((long)((long)rate))}));
            }
            return list;
        }));
        this.func_230480_a_((Widget)new GuiTurbineTab((IGuiWrapper)this, (TileEntityTurbineCasing)this.tile, GuiTurbineTab.TurbineTab.STAT));
        this.func_230480_a_((Widget)new GuiVerticalPowerBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public ITextComponent getTooltip() {
                TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)GuiIndustrialTurbine.this.tile).getMultiblock();
                if (multiblock.isFormed()) {
                    return EnergyDisplay.of((FloatingLong)multiblock.energyContainer.getEnergy(), (FloatingLong)multiblock.energyContainer.getMaxEnergy()).getTextComponent();
                }
                return EnergyDisplay.ZERO.getTextComponent();
            }

            public double getLevel() {
                TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)GuiIndustrialTurbine.this.tile).getMultiblock();
                if (multiblock.isFormed()) {
                    return multiblock.energyContainer.getEnergy().divideToLevel(multiblock.energyContainer.getMaxEnergy());
                }
                return 1.0;
            }
        }, 164, 16));
        this.func_230480_a_((Widget)new GuiVerticalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public ITextComponent getTooltip() {
                return GeneratorsLang.TURBINE_STEAM_INPUT_RATE.translate(new Object[]{GuiIndustrialTurbine.formatInt((long)((TurbineMultiblockData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).getMultiblock()).lastSteamInput)});
            }

            public double getLevel() {
                TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)GuiIndustrialTurbine.this.tile).getMultiblock();
                if (!multiblock.isFormed()) {
                    return 0.0;
                }
                double rate = Math.min((double)(multiblock.lowerVolume * multiblock.clientDispersers) * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get(), (double)multiblock.vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
                if (rate == 0.0) {
                    return 0.0;
                }
                return Math.min(1.0, (double)multiblock.lastSteamInput / rate);
            }
        }, 40, 13));
        this.func_230480_a_((Widget)new GuiGasGauge(() -> ((TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock()).gasTank, () -> ((TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.MEDIUM, (IGuiWrapper)this, 6, 13));
        this.func_230480_a_((Widget)new GuiEnergyTab(() -> {
            EnergyDisplay producing;
            EnergyDisplay storing;
            TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock();
            if (multiblock.isFormed()) {
                storing = EnergyDisplay.of((FloatingLong)multiblock.energyContainer.getEnergy(), (FloatingLong)multiblock.energyContainer.getMaxEnergy());
                producing = EnergyDisplay.of((FloatingLong)((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply(multiblock.clientFlow * (long)Math.min(multiblock.blades, multiblock.coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get())));
            } else {
                storing = EnergyDisplay.ZERO;
                producing = EnergyDisplay.ZERO;
            }
            return Arrays.asList(MekanismLang.STORING.translate(new Object[]{storing}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{producing}));
        }, (IGuiWrapper)this));
        this.func_230480_a_((Widget)new GuiGasMode((IGuiWrapper)this, this.field_147003_i + 159, this.field_147009_r + 72, true, () -> ((TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock()).dumpMode, ((TileEntityTurbineCasing)this.tile).func_174877_v(), 0));
    }

    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitleText(matrix, (ITextComponent)GeneratorsLang.TURBINE.translate(new Object[0]), 5.0f);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

