/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.client.gui.element.GuiTurbineTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class GuiTurbineStats
extends GuiMekanismTile<TileEntityTurbineCasing, EmptyTileContainer<TileEntityTurbineCasing>> {
    public GuiTurbineStats(EmptyTileContainer<TileEntityTurbineCasing> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new GuiTurbineTab((IGuiWrapper)this, (TileEntityTurbineCasing)this.tile, GuiTurbineTab.TurbineTab.MAIN));
        this.func_230480_a_((Widget)new GuiEnergyTab(() -> {
            EnergyDisplay producing;
            EnergyDisplay storing;
            TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock();
            if (multiblock.isFormed()) {
                storing = EnergyDisplay.of((FloatingLong)multiblock.energyContainer.getEnergy(), (FloatingLong)multiblock.energyContainer.getMaxEnergy());
                producing = EnergyDisplay.of((FloatingLong)((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply(multiblock.clientFlow * (long)Math.min(multiblock.blades, multiblock.coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get())));
            } else {
                storing = EnergyDisplay.ZERO;
                producing = EnergyDisplay.ZERO;
            }
            return Arrays.asList(MekanismLang.STORING.translate(new Object[]{storing}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{producing}));
        }, (IGuiWrapper)this));
    }

    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitleText(matrix, (ITextComponent)GeneratorsLang.TURBINE_STATS.translate(new Object[0]), this.field_238743_q_);
        TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock();
        if (multiblock.isFormed()) {
            IFormattableTextComponent limiting = GeneratorsLang.IS_LIMITING.translateColored(EnumColor.DARK_RED, new Object[0]);
            int lowerVolume = multiblock.lowerVolume;
            int clientDispersers = multiblock.clientDispersers;
            int vents = multiblock.vents;
            this.drawString(matrix, (ITextComponent)GeneratorsLang.TURBINE_TANK_VOLUME.translate(new Object[]{lowerVolume}), 8, 26, this.titleTextColor());
            boolean dispersersLimiting = (double)(lowerVolume * clientDispersers) * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get() < (double)vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get();
            boolean ventsLimiting = (double)(lowerVolume * clientDispersers) * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get() > (double)vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get();
            this.drawString(matrix, (ITextComponent)GeneratorsLang.TURBINE_STEAM_FLOW.translate(new Object[0]), 8, 40, this.subheadingTextColor());
            this.drawString(matrix, (ITextComponent)GeneratorsLang.TURBINE_DISPERSERS.translate(new Object[]{clientDispersers, dispersersLimiting ? limiting : ""}), 14, 49, this.titleTextColor());
            this.drawString(matrix, (ITextComponent)GeneratorsLang.TURBINE_VENTS.translate(new Object[]{vents, ventsLimiting ? limiting : ""}), 14, 58, this.titleTextColor());
            int coils = multiblock.coils;
            int blades = multiblock.blades;
            this.drawString(matrix, (ITextComponent)GeneratorsLang.TURBINE_PRODUCTION.translate(new Object[0]), 8, 72, this.subheadingTextColor());
            this.drawString(matrix, (ITextComponent)GeneratorsLang.TURBINE_BLADES.translate(new Object[]{blades, coils * 4 > blades ? limiting : ""}), 14, 81, this.titleTextColor());
            this.drawString(matrix, (ITextComponent)GeneratorsLang.TURBINE_COILS.translate(new Object[]{coils, coils * 4 < blades ? limiting : ""}), 14, 90, this.titleTextColor());
            FloatingLong energyMultiplier = ((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply((long)Math.min(blades, coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
            double rate = (double)lowerVolume * ((double)clientDispersers * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get());
            rate = Math.min(rate, (double)vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
            this.drawString(matrix, (ITextComponent)GeneratorsLang.TURBINE_MAX_PRODUCTION.translate(new Object[]{EnergyDisplay.of((FloatingLong)energyMultiplier.multiply(rate))}), 8, 104, this.titleTextColor());
            this.drawString(matrix, (ITextComponent)GeneratorsLang.TURBINE_MAX_WATER_OUTPUT.translate(new Object[]{multiblock.condensers * MekanismGeneratorsConfig.generators.condenserRate.get()}), 8, 113, this.titleTextColor());
        }
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

