/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fission;

import java.util.List;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class FissionReactorCache
extends MultiblockCache<FissionReactorMultiblockData> {
    private double reactorDamage;
    private double rateLimit = -1.0;
    private double burnRemaining;
    private double partialWaste;
    public boolean active;

    private double getRateLimit() {
        if (this.rateLimit == -1.0) {
            return 0.1;
        }
        return this.rateLimit;
    }

    public void merge(MultiblockCache<FissionReactorMultiblockData> mergeCache, List<ItemStack> rejectedItems) {
        super.merge(mergeCache, rejectedItems);
        this.reactorDamage = Math.max(this.reactorDamage, ((FissionReactorCache)mergeCache).reactorDamage);
        this.rateLimit = Math.max(this.rateLimit, ((FissionReactorCache)mergeCache).rateLimit);
        this.burnRemaining = Math.max(this.burnRemaining, ((FissionReactorCache)mergeCache).burnRemaining);
        this.partialWaste = Math.max(this.partialWaste, ((FissionReactorCache)mergeCache).partialWaste);
        this.active |= ((FissionReactorCache)mergeCache).active;
    }

    public void apply(FissionReactorMultiblockData data) {
        super.apply((MultiblockData)data);
        data.reactorDamage = this.reactorDamage;
        data.rateLimit = this.getRateLimit();
        data.burnRemaining = this.burnRemaining;
        data.partialWaste = this.partialWaste;
        data.setActive(this.active);
    }

    public void sync(FissionReactorMultiblockData data) {
        super.sync((MultiblockData)data);
        this.reactorDamage = data.reactorDamage;
        this.rateLimit = data.rateLimit;
        this.burnRemaining = data.burnRemaining;
        this.partialWaste = data.partialWaste;
        this.active = data.isActive();
    }

    public void load(CompoundNBT nbtTags) {
        super.load(nbtTags);
        this.reactorDamage = nbtTags.func_74769_h("reactorDamage");
        NBTUtils.setDoubleIfPresent((CompoundNBT)nbtTags, (String)"injectionRate", value -> {
            this.rateLimit = value;
        });
        this.burnRemaining = nbtTags.func_74769_h("burnTime");
        this.partialWaste = nbtTags.func_74769_h("partialWaste");
        this.active = nbtTags.func_74767_n("active");
    }

    public void save(CompoundNBT nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74780_a("reactorDamage", this.reactorDamage);
        nbtTags.func_74780_a("injectionRate", this.getRateLimit());
        nbtTags.func_74780_a("burnTime", this.burnRemaining);
        nbtTags.func_74780_a("partialWaste", this.partialWaste);
        nbtTags.func_74757_a("active", this.active);
    }
}

