/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class TileEntitySolarGenerator
extends TileEntityGenerator {
    private static final FloatingLong RAIN_MULTIPLIER = FloatingLong.createConst((double)0.2);
    private boolean seesSun;
    private boolean needsRainCheck = true;
    private FloatingLong peakOutput = FloatingLong.ZERO;
    private boolean settingsChecked;
    private FloatingLong lastProductionAmount = FloatingLong.ZERO;
    private EnergyInventorySlot energySlot;

    public TileEntitySolarGenerator() {
        this((IBlockProvider)GeneratorsBlocks.SOLAR_GENERATOR, ((FloatingLong)MekanismGeneratorsConfig.generators.solarGeneration.get()).multiply(2L));
    }

    public TileEntitySolarGenerator(IBlockProvider blockProvider, @Nonnull FloatingLong output) {
        super(blockProvider, output);
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntitySolarGenerator)this).getDirection());
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)this, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    public boolean canSeeSun() {
        return this.seesSun;
    }

    protected void recheckSettings() {
        World world = this.func_145831_w();
        if (world == null) {
            return;
        }
        Biome b = world.func_225523_d_().func_226836_a_(this.func_174877_v());
        this.needsRainCheck = b.func_201851_b() != Biome.RainType.NONE;
        float tempEff = 0.3f * (0.8f - b.func_225486_c(this.func_174877_v()));
        float humidityEff = -0.3f * (this.needsRainCheck ? b.func_76727_i() : 0.0f);
        this.peakOutput = this.getConfiguredMax().multiply((double)(1.0f + tempEff + humidityEff));
        this.settingsChecked = true;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (!this.settingsChecked) {
            this.recheckSettings();
        }
        this.energySlot.drainContainer();
        World world = this.func_145831_w();
        if (world != null) {
            boolean bl = this.seesSun = world.func_72935_r() && this.canSeeSky() && world.func_230315_m_().func_218272_d();
        }
        if (this.seesSun && MekanismUtils.canFunction((TileEntity)this) && !this.getEnergyContainer().getNeeded().isZero()) {
            this.setActive(true);
            FloatingLong production = this.getProduction();
            this.lastProductionAmount = production.subtract(this.getEnergyContainer().insert(production, Action.EXECUTE, AutomationType.INTERNAL));
        } else {
            this.setActive(false);
            this.lastProductionAmount = FloatingLong.ZERO;
        }
    }

    protected boolean canSeeSky() {
        World world = this.func_145831_w();
        return world != null && world.func_175710_j(this.func_174877_v());
    }

    public FloatingLong getProduction() {
        World world = this.func_145831_w();
        if (world == null) {
            return FloatingLong.ZERO;
        }
        float brightness = WorldUtils.getSunBrightness((World)world, (float)1.0f);
        FloatingLong production = this.peakOutput.multiply((double)brightness);
        if (this.needsRainCheck && (world.func_72896_J() || world.func_72911_I())) {
            production = production.timesEqual(RAIN_MULTIPLIER);
        }
        return production;
    }

    @Override
    protected RelativeSide getEnergySide() {
        return RelativeSide.BOTTOM;
    }

    protected FloatingLong getConfiguredMax() {
        return (FloatingLong)MekanismGeneratorsConfig.generators.solarGeneration.get();
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public FloatingLong getMaxOutput() {
        return this.peakOutput;
    }

    public FloatingLong getLastProductionAmount() {
        return this.lastProductionAmount;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableBoolean.create(this::canSeeSun, value -> {
            this.seesSun = value;
        }));
        container.track((ISyncableData)SyncableFloatingLong.create(this::getMaxOutput, value -> {
            this.peakOutput = value;
        }));
        container.track((ISyncableData)SyncableFloatingLong.create(this::getLastProductionAmount, value -> {
            this.lastProductionAmount = value;
        }));
    }
}

