/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class ItemCollector
extends Item {
    public static final String NBT_Z = "Z";
    public static final String NBT_Y = "Y";
    public static final String NBT_X = "X";
    public static final String NBT_DIM = "dimension";
    public static final String NBT_BOUND = "bound";

    public ItemCollector(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    protected ItemStack findAmmo(PlayerEntity player, Item item) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (itemstack.func_77973_b() != item) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void onEntityItemPickupEvent(EntityItemPickupEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && event.getItem() != null && !event.getItem().func_92059_d().func_190926_b()) {
            ItemStack item = event.getItem().func_92059_d();
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            World world = player.field_70170_p;
            DimPos dp = this.getPosStored(this.findAmmo(player, this));
            if (dp != null && !world.field_72995_K) {
                ServerWorld serverTargetWorld = DimPos.stringDimensionLookup(dp.getDimension(), world.func_73046_m());
                if (serverTargetWorld == null) {
                    StorageNetwork.LOGGER.error("Missing dimension key " + dp.getDimension());
                    return;
                }
                TileEntity tile = serverTargetWorld.func_175625_s(dp.getBlockPos());
                if (tile instanceof TileMain) {
                    TileMain network = (TileMain)tile;
                    int countUnmoved = network.insertStack(item, false);
                    if (countUnmoved == 0) {
                        StorageNetwork.log("unmoved is zero so all gone" + item);
                        item.func_190920_e(0);
                        event.getItem().func_92058_a(item);
                        event.getItem().func_70106_y();
                    }
                } else {
                    StorageNetwork.log("item.remote.notfound");
                }
            }
        }
    }

    public static void putPos(ItemStack stack, BlockPos pos) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74768_a(NBT_X, pos.func_177958_n());
        tag.func_74768_a(NBT_Y, pos.func_177956_o());
        tag.func_74768_a(NBT_Z, pos.func_177952_p());
    }

    public static BlockPos getPos(ItemStack stack) {
        return null;
    }

    public static String getDim(ItemStack stack) {
        return stack.func_196082_o().func_74779_i(NBT_DIM);
    }

    public static void putDim(ItemStack stack, World world) {
        stack.func_196082_o().func_74778_a(NBT_DIM, DimPos.dimensionToString(world));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (world.func_175625_s(pos) instanceof TileMain) {
            ItemStack stack = player.func_184586_b(hand);
            CompoundNBT tag = stack.func_196082_o();
            ItemCollector.putPos(stack, pos);
            tag.func_74757_a(NBT_BOUND, true);
            ItemCollector.putDim(stack, world);
            stack.func_77982_d(tag);
            UtilTileEntity.statusMessage(player, "item.remote.connected");
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t;
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_196082_o();
            int x = tag.func_74762_e(NBT_X);
            int y = tag.func_74762_e(NBT_Y);
            int z = tag.func_74762_e(NBT_Z);
            String dim = tag.func_74779_i(NBT_DIM);
            t = new TranslationTextComponent("[" + x + ", " + y + ", " + z + ", " + dim + "]");
            t.func_240699_a_(TextFormatting.GRAY);
            tooltip.add((ITextComponent)t);
        }
        t = new TranslationTextComponent(this.func_77658_a() + ".tooltip");
        t.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)t);
    }

    public DimPos getPosStored(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() != this || !stack.func_196082_o().func_74767_n(NBT_BOUND)) {
            return null;
        }
        CompoundNBT tag = stack.func_196082_o();
        return new DimPos(tag);
    }
}

