/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.gui.ContainerNetwork;
import com.lothrazar.storagenetwork.network.ClearRecipeMessage;
import com.lothrazar.storagenetwork.network.StackRefreshClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.util.UtilInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class RecipeMessage {
    private CompoundNBT nbt;
    private int index = 0;

    private RecipeMessage() {
    }

    public RecipeMessage(CompoundNBT nbt) {
        this.nbt = nbt;
    }

    public static RecipeMessage decode(PacketBuffer buf) {
        RecipeMessage message = new RecipeMessage();
        message.index = buf.readInt();
        message.nbt = buf.func_150793_b();
        return message;
    }

    public static void encode(RecipeMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.index);
        buf.func_150786_a(msg.nbt);
    }

    public static void handle(RecipeMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (!(player.field_71070_bA instanceof ContainerNetwork)) {
                return;
            }
            ContainerNetwork ctr = (ContainerNetwork)player.field_71070_bA;
            TileMain main = ctr.getTileMain();
            if (main == null) {
                StorageNetwork.log("Recipe message cancelled, null tile");
                return;
            }
            ClearRecipeMessage.clearContainerRecipe(player, false);
            CraftingInventory craftMatrix = ctr.getCraftMatrix();
            for (int slot = 0; slot < 9; ++slot) {
                int i;
                HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
                boolean isOreDict = false;
                ListNBT invList = message.nbt.func_150295_c("s" + slot, 10);
                for (i = 0; i < invList.size(); ++i) {
                    CompoundNBT stackTag = invList.func_150305_b(i);
                    ItemStack s = ItemStack.func_199557_a((CompoundNBT)stackTag);
                    map.put(i, s);
                }
                for (i = 0; i < map.size(); ++i) {
                    ItemStack ex;
                    ItemStack stackCurrent = (ItemStack)map.get(i);
                    if (stackCurrent == null || stackCurrent.func_190926_b()) continue;
                    ItemStackMatcher itemStackMatcher = new ItemStackMatcher(stackCurrent);
                    itemStackMatcher.setNbt(true);
                    itemStackMatcher.setOre(isOreDict);
                    if (stackCurrent.func_77958_k() > 0) {
                        // empty if block
                    }
                    if ((ex = UtilInventory.extractItem((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), itemStackMatcher, 1, true)) != null && !ex.func_190926_b() && craftMatrix.func_70301_a(slot).func_190926_b()) {
                        UtilInventory.extractItem((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), itemStackMatcher, 1, false);
                        craftMatrix.func_70299_a(slot, ex);
                        break;
                    }
                    if ((stackCurrent = main.request(!stackCurrent.func_190926_b() ? itemStackMatcher : null, 1, false)).func_190926_b() || !craftMatrix.func_70301_a(slot).func_190926_b()) continue;
                    craftMatrix.func_70299_a(slot, stackCurrent);
                    break;
                }
                ctr.slotChanged();
                List<ItemStack> list = main.getStacks();
                PacketRegistry.INSTANCE.sendTo((Object)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

