/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.api.IGuiNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class StackRefreshClientMessage {
    private final int size;
    private final int csize;
    private final List<ItemStack> stacks;
    private final List<ItemStack> craftableStacks;

    public StackRefreshClientMessage(List<ItemStack> stacks, List<ItemStack> craftableStacks) {
        this.stacks = stacks;
        this.craftableStacks = craftableStacks;
        this.size = stacks.size();
        this.csize = craftableStacks.size();
    }

    public static void handle(StackRefreshClientMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r instanceof IGuiNetwork) {
                IGuiNetwork gui = (IGuiNetwork)mc.field_71462_r;
                gui.setStacks(message.stacks);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void encode(StackRefreshClientMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.size);
        buf.writeInt(msg.csize);
        for (ItemStack stack : msg.stacks) {
            buf.func_150786_a(stack.serializeNBT());
            buf.writeInt(stack.func_190916_E());
        }
        for (ItemStack stack : msg.craftableStacks) {
            buf.func_150786_a(stack.serializeNBT());
            buf.writeInt(stack.func_190916_E());
        }
    }

    public static StackRefreshClientMessage decode(PacketBuffer buf) {
        ItemStack stack;
        int size = buf.readInt();
        int csize = buf.readInt();
        ArrayList stacks = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            CompoundNBT stacktag = buf.func_150793_b();
            stack = ItemStack.func_199557_a((CompoundNBT)stacktag);
            stack.func_190920_e(buf.readInt());
            stacks.add(stack);
        }
        ArrayList craftableStacks = Lists.newArrayList();
        for (int i = 0; i < csize; ++i) {
            stack = ItemStack.func_199557_a((CompoundNBT)buf.func_150793_b());
            stack.func_190920_e(buf.readInt());
            craftableStacks.add(stack);
        }
        return new StackRefreshClientMessage(stacks, craftableStacks);
    }
}

