/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.block;

import codechicken.lib.internal.ExceptionMessageEventHandler;
import codechicken.lib.internal.proxy.ProxyClient;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.util.LambdaUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CCBlockRendererDispatcher
extends BlockRendererDispatcher {
    private static final Logger logger = LogManager.getLogger();
    public final BlockRendererDispatcher parentDispatcher;
    private static long lastTime;

    public CCBlockRendererDispatcher(BlockRendererDispatcher parent, BlockColors blockColours) {
        super(parent.func_175023_a(), blockColours);
        this.parentDispatcher = parent;
        this.field_175027_c = parent.field_175027_c;
        this.field_175025_e = parent.field_175025_e;
        this.field_175028_a = parent.field_175028_a;
    }

    public boolean renderModel(BlockState state, BlockPos pos, IBlockDisplayReader world, MatrixStack stack, IVertexBuilder builder, boolean checkSides, Random rand, IModelData modelData) {
        try {
            Optional<ICCBlockRenderer> renderOpt = BlockRenderingRegistry.getBlockRenderers().stream().filter(e -> e.canHandleBlock(world, pos, state)).findFirst();
            if (renderOpt.isPresent()) {
                return renderOpt.get().renderBlock(state, pos, world, stack, builder, rand, modelData);
            }
        }
        catch (Throwable t) {
            if (ProxyClient.catchBlockRenderExceptions) {
                CCBlockRendererDispatcher.handleCaughtException(t, state, pos, world);
                return false;
            }
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)t, (String)"Tessellating CCL block in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tessellated");
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (BlockState)state);
            throw new ReportedException(crashreport);
        }
        try {
            return this.parentDispatcher.renderModel(state, pos, world, stack, builder, checkSides, rand, modelData);
        }
        catch (Throwable t) {
            if (ProxyClient.catchBlockRenderExceptions) {
                CCBlockRendererDispatcher.handleCaughtException(t, state, pos, world);
                return false;
            }
            throw t;
        }
    }

    public void renderBlockDamage(BlockState state, BlockPos pos, IBlockDisplayReader world, MatrixStack matrixStackIn, IVertexBuilder vertexBuilderIn, IModelData data) {
        Optional<ICCBlockRenderer> renderOpt = BlockRenderingRegistry.getBlockRenderers().stream().filter(e -> e.canHandleBlock(world, pos, state)).findFirst();
        if (renderOpt.isPresent()) {
            renderOpt.get().renderBreaking(state, pos, world, matrixStackIn, vertexBuilderIn, data);
        } else {
            this.parentDispatcher.renderBlockDamage(state, pos, world, matrixStackIn, vertexBuilderIn, data);
        }
    }

    public boolean func_228794_a_(BlockPos pos, IBlockDisplayReader world, IVertexBuilder builder, FluidState state) {
        Optional<ICCBlockRenderer> renderOpt = BlockRenderingRegistry.getBlockRenderers().stream().filter(e -> e.canHandleFluid(world, pos, state)).findFirst();
        if (renderOpt.isPresent()) {
            return renderOpt.get().renderFluid(pos, world, builder, state);
        }
        return this.parentDispatcher.func_228794_a_(pos, world, builder, state);
    }

    public void renderBlock(BlockState blockStateIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferTypeIn, int combinedLightIn, int combinedOverlayIn, IModelData modelData) {
        Optional<ICCBlockRenderer> renderOpt = BlockRenderingRegistry.getBlockRenderers().stream().filter(e -> e.canHandleEntity(blockStateIn)).findFirst();
        if (renderOpt.isPresent()) {
            renderOpt.get().renderEntity(blockStateIn, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn, modelData);
        } else {
            this.parentDispatcher.renderBlock(blockStateIn, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn, modelData);
        }
    }

    private static void handleCaughtException(Throwable t, BlockState inState, BlockPos pos, IBlockDisplayReader world) {
        long time;
        Block inBlock = inState.func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        StringBuilder builder = new StringBuilder("\n CCL has caught an exception whilst rendering a block\n");
        builder.append("  BlockPos:      ").append(String.format("x:%s, y:%s, z:%s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).append("\n");
        builder.append("  Block Class:   ").append(LambdaUtils.tryOrNull(() -> inBlock.getClass())).append("\n");
        builder.append("  Registry Name: ").append(LambdaUtils.tryOrNull(() -> inBlock.getRegistryName())).append("\n");
        builder.append("  State:         ").append(inState).append("\n");
        builder.append(" Tile at position\n");
        builder.append("  Tile Class:    ").append(LambdaUtils.tryOrNull(() -> tile.getClass())).append("\n");
        builder.append("  Tile Id:       ").append(LambdaUtils.tryOrNull(() -> TileEntityType.func_200969_a((TileEntityType)tile.func_200662_C()))).append("\n");
        builder.append("  Tile NBT:      ").append(LambdaUtils.tryOrNull(() -> tile.func_189515_b(new CompoundNBT()))).append("\n");
        builder.append("This functionality can be disabled in the CCL config file.\n");
        if (ProxyClient.messagePlayerOnRenderExceptionCaught) {
            builder.append("You can also turn off player messages in the CCL config file.\n");
        }
        String logMessage = builder.toString();
        String key = ExceptionUtils.getStackTrace((Throwable)t) + logMessage;
        if (ExceptionMessageEventHandler.exceptionMessageCache.add(key)) {
            logger.error(logMessage, t);
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (ProxyClient.messagePlayerOnRenderExceptionCaught && player != null && TimeUnit.NANOSECONDS.toSeconds((time = System.nanoTime()) - lastTime) > 5L) {
            lastTime = time;
            player.func_145747_a((ITextComponent)new StringTextComponent("CCL Caught an exception rendering a block. See the log for info."), Util.field_240973_b_);
        }
    }
}

