/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.optifine.Config;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class Lang {
    private static final Splitter splitter = Splitter.on((char)'=').limit(2);
    private static final Pattern pattern = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");

    public static void resourcesReloaded() {
        HashMap localeProperties = new HashMap();
        ArrayList<String> listFiles = new ArrayList<String>();
        String PREFIX = "optifine/lang/";
        String EN_US = "en_us";
        String SUFFIX = ".lang";
        listFiles.add(PREFIX + EN_US + SUFFIX);
        if (!Config.getGameSettings().aV.equals(EN_US)) {
            listFiles.add(PREFIX + Config.getGameSettings().aV + SUFFIX);
        }
        String[] files = listFiles.toArray(new String[listFiles.size()]);
        Lang.loadResources((abj)Config.getDefaultResourcePack(), files, localeProperties);
        abj[] resourcePacks = Config.getResourcePacks();
        for (int i = 0; i < resourcePacks.length; ++i) {
            abj rp = resourcePacks[i];
            Lang.loadResources(rp, files, localeProperties);
        }
    }

    private static void loadResources(abj rp, String[] files, Map localeProperties) {
        try {
            for (int i = 0; i < files.length; ++i) {
                InputStream in;
                String file = files[i];
                vk loc = new vk(file);
                if (!rp.b(abk.a, loc) || (in = rp.a(abk.a, loc)) == null) continue;
                Lang.loadLocaleData(in, localeProperties);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void loadLocaleData(InputStream is, Map localeProperties) throws IOException {
        Iterator it = IOUtils.readLines((InputStream)is, (Charset)Charsets.UTF_8).iterator();
        is.close();
        while (it.hasNext()) {
            String[] parts;
            String line = (String)it.next();
            if (line.isEmpty() || line.charAt(0) == '#' || (parts = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)line), String.class)) == null || parts.length != 2) continue;
            String key = parts[0];
            String value = pattern.matcher(parts[1]).replaceAll("%$1s");
            localeProperties.put(key, value);
        }
    }

    public static void loadResources(ach resourceManager, String langCode, Map<String, String> map) {
        try {
            String pathLang = "optifine/lang/" + langCode + ".lang";
            vk locLang = new vk(pathLang);
            acg res = resourceManager.a(locLang);
            InputStream is = res.b();
            Lang.loadLocaleData(is, map);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String get(String key) {
        return ekx.a((String)key, (Object[])new Object[0]);
    }

    public static of getComponent(String key) {
        return new of(key);
    }

    public static String get(String key, String def) {
        String str = ekx.a((String)key, (Object[])new Object[0]);
        if (str == null || str.equals(key)) {
            return def;
        }
        return str;
    }

    public static String getOn() {
        return ekx.a((String)"options.on", (Object[])new Object[0]);
    }

    public static String getOff() {
        return ekx.a((String)"options.off", (Object[])new Object[0]);
    }

    public static String getFast() {
        return ekx.a((String)"options.graphics.fast", (Object[])new Object[0]);
    }

    public static String getFancy() {
        return ekx.a((String)"options.graphics.fancy", (Object[])new Object[0]);
    }

    public static String getDefault() {
        return ekx.a((String)"generator.default", (Object[])new Object[0]);
    }
}

