/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.misc.EnergyUtils;

public class FluxConfig {
    private static final ClientConfig CLIENT_CONFIG;
    private static final ForgeConfigSpec CLIENT_SPEC;
    private static final CommonConfig COMMON_CONFIG;
    private static final ForgeConfigSpec COMMON_SPEC;
    public static boolean enableButtonSound;
    public static boolean enableOneProbeBasicInfo;
    public static boolean enableOneProbeAdvancedInfo;
    public static boolean enableOneProbeSneaking;
    public static boolean enableFluxRecipe;
    public static boolean enableChunkLoading;
    public static boolean enableSuperAdmin;
    public static long defaultLimit;
    public static long basicCapacity;
    public static long basicTransfer;
    public static long herculeanCapacity;
    public static long herculeanTransfer;
    public static long gargantuanCapacity;
    public static long gargantuanTransfer;
    public static int maximumPerPlayer;
    public static int superAdminRequiredPermission;
    public static List<String> blockBlacklistStrings;
    public static List<String> itemBlackListStrings;
    public static boolean enableGuiDebug;

    static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(FluxConfig::reloadConfig);
    }

    static void reloadConfig(@Nonnull ModConfig.ModConfigEvent event) {
        ForgeConfigSpec spec = event.getConfig().getSpec();
        if (spec == COMMON_SPEC) {
            FluxConfig.bakeCommonConfig();
            EnergyUtils.reloadBlacklist();
            FluxNetworks.LOGGER.info("COMMON CONFIG LOADED");
        } else if (spec == CLIENT_SPEC) {
            FluxConfig.bakeClientConfig();
            FluxNetworks.LOGGER.info("CLIENT CONFIG LOADED");
        }
    }

    public static void bakeCommonConfig() {
        CommonConfig config = COMMON_CONFIG;
        defaultLimit = (Long)config.defaultLimit.get();
        basicCapacity = (Long)config.basicCapacity.get();
        basicTransfer = (Long)config.basicTransfer.get();
        herculeanCapacity = (Long)config.herculeanCapacity.get();
        herculeanTransfer = (Long)config.herculeanTransfer.get();
        gargantuanCapacity = (Long)config.gargantuanCapacity.get();
        gargantuanTransfer = (Long)config.gargantuanTransfer.get();
        maximumPerPlayer = (Integer)config.maximumPerPlayer.get();
        superAdminRequiredPermission = (Integer)config.superAdminRequiredPermission.get();
        enableSuperAdmin = (Boolean)config.enableSuperAdmin.get();
        enableFluxRecipe = (Boolean)config.enableFluxRecipe.get();
        enableChunkLoading = (Boolean)config.enableChunkLoading.get();
        blockBlacklistStrings = (List)config.blockBlacklistStrings.get();
        itemBlackListStrings = (List)config.itemBlackListStrings.get();
    }

    public static void bakeClientConfig() {
        ClientConfig config = CLIENT_CONFIG;
        enableButtonSound = (Boolean)config.enableButtonSound.get();
        enableOneProbeBasicInfo = (Boolean)config.enableOneProbeBasicInfo.get();
        enableOneProbeAdvancedInfo = (Boolean)config.enableOneProbeAdvancedInfo.get();
        enableOneProbeSneaking = (Boolean)config.enableOneProbeSneaking.get();
        enableGuiDebug = (Boolean)config.enableGuiDebug.get();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        COMMON_CONFIG = new CommonConfig(builder);
        COMMON_SPEC = builder.build();
        builder = new ForgeConfigSpec.Builder();
        CLIENT_CONFIG = new ClientConfig(builder);
        CLIENT_SPEC = builder.build();
    }

    private static class ClientConfig {
        private final ForgeConfigSpec.BooleanValue enableButtonSound;
        private final ForgeConfigSpec.BooleanValue enableOneProbeBasicInfo;
        private final ForgeConfigSpec.BooleanValue enableOneProbeAdvancedInfo;
        private final ForgeConfigSpec.BooleanValue enableOneProbeSneaking;
        private final ForgeConfigSpec.BooleanValue enableGuiDebug;

        ClientConfig(@Nonnull ForgeConfigSpec.Builder builder) {
            builder.push("gui");
            this.enableButtonSound = builder.comment("Enable navigation buttons sound when pressing it").translation("fluxnetworks.config.enableButtonSound").define("enableButtonSound", true);
            this.enableGuiDebug = builder.comment("Internal use only! Keep this to false!").define("enableGuiDebug", false);
            builder.pop();
            builder.push("OneProbe");
            this.enableOneProbeBasicInfo = builder.comment("Displays: Network Name, Live Transfer Rate & Internal Buffer").translation("fluxnetworks.config.enableOneProbeBasicInfo").define("enableOneProbeBasicInfo", true);
            this.enableOneProbeAdvancedInfo = builder.comment("Displays: Transfer Limit & Priority etc").translation("fluxnetworks.config.enableOneProbeAdvancedInfo").define("enableOneProbeAdvancedInfo", true);
            this.enableOneProbeSneaking = builder.comment("Displays Advanced Info when sneaking only").translation("fluxnetworks.config.enableOneProbeSneaking").define("enableOneProbeSneaking", true);
            builder.pop();
        }
    }

    private static class CommonConfig {
        private final ForgeConfigSpec.LongValue defaultLimit;
        private final ForgeConfigSpec.LongValue basicCapacity;
        private final ForgeConfigSpec.LongValue basicTransfer;
        private final ForgeConfigSpec.LongValue herculeanCapacity;
        private final ForgeConfigSpec.LongValue herculeanTransfer;
        private final ForgeConfigSpec.LongValue gargantuanCapacity;
        private final ForgeConfigSpec.LongValue gargantuanTransfer;
        private final ForgeConfigSpec.IntValue maximumPerPlayer;
        private final ForgeConfigSpec.IntValue superAdminRequiredPermission;
        private final ForgeConfigSpec.BooleanValue enableSuperAdmin;
        private final ForgeConfigSpec.BooleanValue enableFluxRecipe;
        private final ForgeConfigSpec.BooleanValue enableChunkLoading;
        private final ForgeConfigSpec.ConfigValue<List<String>> blockBlacklistStrings;
        private final ForgeConfigSpec.ConfigValue<List<String>> itemBlackListStrings;

        CommonConfig(@Nonnull ForgeConfigSpec.Builder builder) {
            builder.push("energy");
            this.defaultLimit = builder.comment("The default transfer limit of a flux connector").translation("fluxnetworks.config.defaultLimit").defineInRange("defaultLimit", 800000L, 0L, Long.MAX_VALUE);
            this.basicCapacity = builder.translation("fluxnetworks.config.basicCapacity").defineInRange("basicCapacity", 1000000L, 0L, Long.MAX_VALUE);
            this.basicTransfer = builder.translation("fluxnetworks.config.basicTransfer").defineInRange("basicTransfer", 20000L, 0L, Long.MAX_VALUE);
            this.herculeanCapacity = builder.translation("fluxnetworks.config.herculeanCapacity").defineInRange("herculeanCapacity", 8000000L, 0L, Long.MAX_VALUE);
            this.herculeanTransfer = builder.translation("fluxnetworks.config.herculeanTransfer").defineInRange("herculeanTransfer", 120000L, 0L, Long.MAX_VALUE);
            this.gargantuanCapacity = builder.translation("fluxnetworks.config.gargantuanCapacity").defineInRange("gargantuanCapacity", 128000000L, 0L, Long.MAX_VALUE);
            this.gargantuanTransfer = builder.translation("fluxnetworks.config.gargantuanTransfer").defineInRange("gargantuanTransfer", 1440000L, 0L, Long.MAX_VALUE);
            builder.pop();
            builder.push("networks");
            this.maximumPerPlayer = builder.comment("Maximum networks each player can have. -1 = no limit").translation("fluxnetworks.config.maximumPerPlayer").defineInRange("maximumPerPlayer", 5, -1, Integer.MAX_VALUE);
            this.enableSuperAdmin = builder.comment("Allows someone to be a network super admin, otherwise, no one can access or dismantle your flux devices or delete your networks without permission").translation("fluxnetworks.config.enableSuperAdmin").define("enableSuperAdmin", true);
            this.superAdminRequiredPermission = builder.comment("See ops.json. If the player has permission level equal or greater to the value set here they will be able to Activate Super Admin. Setting this to 0 will allow anyone to active Super Admin.").translation("fluxnetworks.config.superAdminRequiredPermission").defineInRange("superAdminRequiredPermission", 1, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("general");
            this.enableFluxRecipe = builder.comment("Enables redstone being compressed with the bedrock and obsidian to get flux").translation("fluxnetworks.config.enableFluxRecipe").define("enableFluxRecipe", true);
            this.enableChunkLoading = builder.comment("Allows flux tiles to work as chunk loaders").translation("fluxnetworks.config.enableChunkLoading").define("enableChunkLoading", true);
            builder.pop();
            builder.push("blacklist");
            this.blockBlacklistStrings = builder.comment("A blacklist for blocks which flux devices shouldn't connect to, use format 'modid:registry_name'").translation("fluxnetworks.config.blockBlacklistStrings").define("blockBlacklistStrings", (Object)Lists.newArrayList((Object[])new String[]{"actuallyadditions:block_phantom_energyface"}));
            this.itemBlackListStrings = builder.comment("A blacklist for items which wireless charging shouldn't charge to, use format 'modid:registry_name'").translation("fluxnetworks.config.itemBlackListStrings").define("itemBlackListStrings", (Object)Lists.newArrayList((Object[])new String[]{""}));
            builder.pop();
        }
    }
}

