/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.popup;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.GlobalPos;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.button.FluxTextWidget;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.button.SimpleToggleButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.client.gui.popup.PopupCore;
import sonar.fluxnetworks.client.gui.tab.GuiTabConnections;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.network.CEditConnectionsMessage;
import sonar.fluxnetworks.common.network.NetworkHandler;

public class PopupConnectionEdit
extends PopupCore<GuiTabConnections> {
    public NormalButton apply;
    public FluxTextWidget fluxName;
    public FluxTextWidget priority;
    public FluxTextWidget limit;
    public SlidedSwitchButton surgeMode;
    public SlidedSwitchButton disableLimit;
    public SlidedSwitchButton chunkLoading;
    public SimpleToggleButton editName;
    public SimpleToggleButton editPriority;
    public SimpleToggleButton editLimit;
    public SimpleToggleButton editSurgeMode;
    public SimpleToggleButton editDisableLimit;
    public SimpleToggleButton editChunkLoading;
    public boolean batchMode;
    private final List<SimpleToggleButton> toggleButtons = new ArrayList<SimpleToggleButton>();

    public PopupConnectionEdit(GuiTabConnections host, PlayerEntity player, boolean batchMode) {
        super(host, player);
        this.batchMode = batchMode;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.toggleButtons.clear();
        this.popButtons.add(new NormalButton(FluxTranslate.CANCEL.t(), 40, 146, 36, 12, 11));
        this.apply = new NormalButton(FluxTranslate.APPLY.t(), 100, 146, 36, 12, 12).setUnclickable();
        this.popButtons.add(this.apply);
        int color = ((GuiTabConnections)this.host).network.getNetworkColor() | 0xFF000000;
        if (this.batchMode) {
            this.fluxName = FluxTextWidget.create(FluxTranslate.NAME.t() + ": ", this.field_230712_o_, this.field_147003_i + 20, this.field_147009_r + 30, 136, 12).setOutlineColor(color);
            this.fluxName.func_146203_f(24);
            this.func_230480_a_((Widget)this.fluxName);
            this.priority = FluxTextWidget.create(FluxTranslate.PRIORITY.t() + ": ", this.field_230712_o_, this.field_147003_i + 20, this.field_147009_r + 47, 136, 12).setOutlineColor(color).setDigitsOnly().setAllowNegatives(true);
            this.priority.func_146203_f(5);
            this.priority.func_146180_a(String.valueOf(0));
            this.func_230480_a_((Widget)this.priority);
            this.limit = FluxTextWidget.create(FluxTranslate.TRANSFER_LIMIT.t() + ": ", this.field_230712_o_, this.field_147003_i + 20, this.field_147009_r + 64, 136, 12).setOutlineColor(color).setDigitsOnly().setMaxValue(Long.MAX_VALUE);
            this.limit.func_146203_f(9);
            this.limit.func_146180_a(String.valueOf(0));
            this.func_230480_a_((Widget)this.limit);
            this.editName = new SimpleToggleButton(10, 33, 0);
            this.editPriority = new SimpleToggleButton(10, 50, 1);
            this.editLimit = new SimpleToggleButton(10, 67, 2);
            this.editSurgeMode = new SimpleToggleButton(10, 82, 3);
            this.editDisableLimit = new SimpleToggleButton(10, 94, 4);
            this.editChunkLoading = new SimpleToggleButton(10, 106, 5);
            this.toggleButtons.add(this.editName);
            this.toggleButtons.add(this.editPriority);
            this.toggleButtons.add(this.editLimit);
            this.toggleButtons.add(this.editSurgeMode);
            this.toggleButtons.add(this.editDisableLimit);
            this.toggleButtons.add(this.editChunkLoading);
            this.surgeMode = new SlidedSwitchButton(140, 82, 1, this.field_147003_i, this.field_147009_r, false);
            this.disableLimit = new SlidedSwitchButton(140, 94, 2, this.field_147003_i, this.field_147009_r, false);
            this.chunkLoading = new SlidedSwitchButton(140, 106, 3, this.field_147003_i, this.field_147009_r, false);
            this.popSwitches.add(this.surgeMode);
            this.popSwitches.add(this.disableLimit);
            this.popSwitches.add(this.chunkLoading);
        } else {
            this.fluxName = FluxTextWidget.create(FluxTranslate.NAME.t() + ": ", this.field_230712_o_, this.field_147003_i + 18, this.field_147009_r + 30, 140, 12).setOutlineColor(color);
            this.fluxName.func_146203_f(24);
            this.fluxName.func_146180_a(((GuiTabConnections)this.host).singleConnection.getCustomName());
            this.fluxName.func_212954_a(string -> {
                this.apply.clickable = true;
            });
            this.func_230480_a_((Widget)this.fluxName);
            this.priority = FluxTextWidget.create(FluxTranslate.PRIORITY.t() + ": ", this.field_230712_o_, this.field_147003_i + 18, this.field_147009_r + 47, 140, 12).setOutlineColor(color).setDigitsOnly().setAllowNegatives(true);
            this.priority.func_146203_f(5);
            this.priority.func_146180_a(String.valueOf(((GuiTabConnections)this.host).singleConnection.getRawPriority()));
            this.priority.func_212954_a(string -> {
                this.apply.clickable = true;
            });
            this.func_230480_a_((Widget)this.priority);
            this.limit = FluxTextWidget.create(FluxTranslate.TRANSFER_LIMIT.t() + ": ", this.field_230712_o_, this.field_147003_i + 18, this.field_147009_r + 64, 140, 12).setOutlineColor(color).setDigitsOnly().setMaxValue(Long.MAX_VALUE);
            this.limit.func_146203_f(9);
            this.limit.func_146180_a(String.valueOf(((GuiTabConnections)this.host).singleConnection.getRawLimit()));
            this.limit.func_212954_a(string -> {
                this.apply.clickable = true;
            });
            this.func_230480_a_((Widget)this.limit);
            this.surgeMode = new SlidedSwitchButton(140, 82, 1, this.field_147003_i, this.field_147009_r, ((GuiTabConnections)this.host).singleConnection.getSurgeMode());
            this.disableLimit = new SlidedSwitchButton(140, 94, 2, this.field_147003_i, this.field_147009_r, ((GuiTabConnections)this.host).singleConnection.getDisableLimit());
            this.popSwitches.add(this.surgeMode);
            this.popSwitches.add(this.disableLimit);
            if (!((GuiTabConnections)this.host).singleConnection.getDeviceType().isStorage()) {
                this.chunkLoading = new SlidedSwitchButton(140, 106, 3, this.field_147003_i, this.field_147009_r, ((GuiTabConnections)this.host).singleConnection.isForcedLoading());
                this.popSwitches.add(this.chunkLoading);
            }
        }
    }

    @Override
    public void func_230451_b_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        for (SlidedSwitchButton slidedSwitchButton : this.popSwitches) {
            slidedSwitchButton.drawButton(this.field_230706_i_, matrixStack, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        }
        for (SimpleToggleButton simpleToggleButton : this.toggleButtons) {
            simpleToggleButton.drawButton(this.field_230706_i_, matrixStack, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        }
        if (!this.batchMode) {
            this.drawCenterText(matrixStack, FluxTranslate.SINGLE_EDIT.t(), 88.0f, 14.0f, 0xFFFFFF);
            this.drawCenterText(matrixStack, FluxUtils.getDisplayPos(((GuiTabConnections)this.host).singleConnection.getGlobalPos()), 88.0f, 121.0f, 0xFFFFFF);
            this.drawCenterText(matrixStack, FluxUtils.getDisplayDim(((GuiTabConnections)this.host).singleConnection.getGlobalPos()), 88.0f, 130.0f, 0xFFFFFF);
        } else {
            this.drawCenterText(matrixStack, FluxTranslate.BATCH_EDIT.t(), 88.0f, 14.0f, 0xFFFFFF);
            this.drawCenterText(matrixStack, FluxTranslate.EDITING_CONNECTIONS.format(((GuiTabConnections)this.host).batchConnections.size()), 88.0f, 122.0f, 0xFFFFFF);
        }
        this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.SURGE_MODE.t(), 20.0f, 82.0f, ((GuiTabConnections)this.host).network.getNetworkColor());
        this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.DISABLE_LIMIT.t(), 20.0f, 94.0f, ((GuiTabConnections)this.host).network.getNetworkColor());
        if (this.batchMode || !((GuiTabConnections)this.host).singleConnection.getDeviceType().isStorage()) {
            this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.CHUNK_LOADING.t(), 20.0f, 106.0f, ((GuiTabConnections)this.host).network.getNetworkColor());
        }
        this.drawCenterText(matrixStack, FluxClientCache.getFeedbackText(), 88.0f, 155.0f, FluxClientCache.getFeedbackColor());
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (NormalButton normalButton : this.popButtons) {
                ArrayList list;
                if (!normalButton.clickable || !normalButton.isMouseHovered(this.field_230706_i_, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r)) continue;
                if (normalButton.id == 11) {
                    ((GuiTabConnections)this.host).closePopUp();
                    return true;
                }
                if (normalButton.id != 12) continue;
                int flags = 0;
                if (this.batchMode) {
                    list = ((GuiTabConnections)this.host).batchConnections.stream().map(IFluxDevice::getGlobalPos).collect(Collectors.toList());
                    if (this.editName.checked) {
                        flags |= 1;
                    }
                    if (this.editPriority.checked) {
                        flags |= 2;
                    }
                    if (this.editLimit.checked) {
                        flags |= 4;
                    }
                    if (this.editSurgeMode.checked) {
                        flags |= 8;
                    }
                    if (this.editDisableLimit.checked) {
                        flags |= 0x10;
                    }
                    if (this.editChunkLoading.checked) {
                        flags |= 0x20;
                    }
                } else {
                    list = Lists.newArrayList((Object[])new GlobalPos[]{((GuiTabConnections)this.host).singleConnection.getGlobalPos()});
                    flags |= 0x3F;
                }
                NetworkHandler.INSTANCE.sendToServer(new CEditConnectionsMessage(((GuiTabConnections)this.host).network.getNetworkID(), list, flags, this.fluxName.func_146179_b(), this.priority.getIntegerFromText(true), this.limit.getLongFromText(false), this.surgeMode != null && this.surgeMode.toggled, this.disableLimit != null && this.disableLimit.toggled, this.chunkLoading != null && this.chunkLoading.toggled));
                return true;
            }
            for (SlidedSwitchButton slidedSwitchButton : this.popSwitches) {
                if (!slidedSwitchButton.isMouseHovered(this.field_230706_i_, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r)) continue;
                slidedSwitchButton.switchButton();
                if (!this.batchMode) {
                    this.apply.clickable = true;
                }
                return true;
            }
            for (SimpleToggleButton simpleToggleButton : this.toggleButtons) {
                if (!simpleToggleButton.isMouseHovered(this.field_230706_i_, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r)) continue;
                simpleToggleButton.checked = !simpleToggleButton.checked;
                this.apply.clickable = this.toggleButtons.stream().anyMatch(b -> b.checked);
                return true;
            }
        }
        return false;
    }
}

