/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.gui.EnumNavigationTab;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.ScreenUtils;
import sonar.fluxnetworks.client.gui.basic.GuiTabPages;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.popup.PopupNetworkPassword;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.common.misc.FluxUtils;

public class GuiTabSelection
extends GuiTabPages<IFluxNetwork> {
    public InvisibleButton redirectButton;
    public IFluxNetwork selectedNetwork;
    protected int timer2;

    public GuiTabSelection(@Nonnull FluxMenu container, @Nonnull PlayerEntity player) {
        super(container, player);
        this.gridStartX = 15;
        this.gridStartY = 22;
        this.gridHeight = 13;
        this.gridPerPage = 10;
        this.elementHeight = 12;
        this.elementWidth = 146;
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_SELECTION;
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        if (this.elements.size() == 0) {
            this.renderNavigationPrompt(matrixStack, FluxTranslate.ERROR_NO_NETWORK.t(), FluxTranslate.TAB_CREATE.t());
        } else {
            String amount = FluxTranslate.TOTAL.t() + ": " + this.elements.size();
            this.field_230712_o_.func_238421_b_(matrixStack, amount, (float)(158 - this.field_230712_o_.func_78256_a(amount)), 10.0f, 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.SORT_BY.t() + ": " + TextFormatting.AQUA + this.sortType.getTranslatedName(), 19.0f, 10.0f, 0xFFFFFF);
            if (!this.hasActivePopup()) {
                this.drawCenterText(matrixStack, FluxClientCache.getFeedbackText(), 88.0f, 150.0f, FluxClientCache.getFeedbackColor());
            }
        }
    }

    @Override
    protected void onElementClicked(IFluxNetwork element, int mouseButton) {
        if (mouseButton == 0) {
            this.selectedNetwork = element;
            this.setConnectedNetwork(element.getNetworkID(), "");
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.configureNavigationButtons(EnumNavigationTab.TAB_SELECTION, this.navigationTabs);
        if (FluxClientCache.getAllNetworks().isEmpty()) {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTab.TAB_CREATE.getTranslatedName(), b -> this.switchTab(EnumNavigationTab.TAB_CREATE));
            this.func_230480_a_((Widget)this.redirectButton);
        }
        this.refreshPages(FluxClientCache.getAllNetworks());
    }

    @Override
    public void renderElement(MatrixStack matrixStack, IFluxNetwork element, int x, int y) {
        GlStateManager.func_227626_N_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227709_e_();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(ScreenUtils.GUI_BAR);
        int color = element.getNetworkColor();
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        boolean selected = ((FluxMenu)this.field_147002_h).bridge.getNetworkID() == element.getNetworkID();
        boolean isEncrypted = element.getSecurity().isEncrypted();
        if (isEncrypted) {
            if (selected) {
                this.func_238474_b_(matrixStack, x + 131, y, 159, 16, 16, this.elementHeight);
            } else {
                this.func_238474_b_(matrixStack, x + 131, y, 175, 16, 16, this.elementHeight);
            }
        }
        String text = element.getNetworkName();
        if (selected) {
            RenderSystem.color3f((float)f, (float)f1, (float)f2);
            this.func_238474_b_(matrixStack, x, y, 0, 16, this.elementWidth, this.elementHeight);
            this.field_230706_i_.field_71466_p.func_238421_b_(matrixStack, text, (float)(x + 4), (float)(y + 2), 0xFFFFFF);
        } else {
            RenderSystem.color3f((float)(f * 0.75f), (float)(f1 * 0.75f), (float)(f2 * 0.75f));
            this.func_238474_b_(matrixStack, x, y, 0, 16, this.elementWidth, this.elementHeight);
            this.field_230706_i_.field_71466_p.func_238421_b_(matrixStack, text, (float)(x + 4), (float)(y + 2), 0x404040);
        }
        GlStateManager.func_227627_O_();
    }

    @Override
    public void renderElementTooltip(MatrixStack matrixStack, IFluxNetwork element, int mouseX, int mouseY) {
        if (this.hasActivePopup()) {
            return;
        }
    }

    @Override
    public boolean mouseClickedMain(double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedMain(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && mouseX > (double)(this.field_147003_i + 45) && mouseX < (double)(this.field_147003_i + 75) && mouseY > (double)(this.field_147009_r + 10) && mouseY < (double)(this.getGuiTop() + 17)) {
            this.sortType = (GuiTabPages.SortType)FluxUtils.incrementEnum((Enum)this.sortType, (Enum[])GuiTabPages.SortType.values());
            this.sortGrids(this.sortType);
            return true;
        }
        return false;
    }

    @Override
    public void onOperationalFeedback(@Nonnull FeedbackInfo info) {
        super.onOperationalFeedback(info);
        if (info == FeedbackInfo.PASSWORD_REQUIRE) {
            this.openPopUp(new PopupNetworkPassword(this, this.player));
        } else if (this.selectedNetwork != null && info == FeedbackInfo.SUCCESS) {
            this.closePopUp();
            if (((FluxMenu)this.field_147002_h).bridge instanceof ItemFluxConfigurator.MenuBridge) {
                ((ItemFluxConfigurator.MenuBridge)((FluxMenu)this.field_147002_h).bridge).networkID = this.selectedNetwork.getNetworkID();
                this.network = this.selectedNetwork;
                this.networkValid = this.selectedNetwork.isValid();
            }
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.timer2 == 9) {
            this.refreshPages(FluxClientCache.getAllNetworks());
        }
        ++this.timer2;
        this.timer2 %= 10;
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        switch (sortType) {
            case ID: {
                this.elements.sort(Comparator.comparing(IFluxNetwork::getNetworkID));
                this.refreshCurrentPageInternal();
                break;
            }
            case NAME: {
                this.elements.sort(Comparator.comparing(IFluxNetwork::getNetworkName));
                this.refreshCurrentPageInternal();
            }
        }
    }
}

