/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.GlobalPos;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.misc.IMessage;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.network.SConnectionUpdateMessage;
import sonar.fluxnetworks.common.storage.FluxNetworkData;

public class CConnectionUpdateMessage
implements IMessage {
    private int networkID;
    private List<GlobalPos> list;

    public CConnectionUpdateMessage() {
    }

    public CConnectionUpdateMessage(int networkID, List<GlobalPos> list) {
        this.networkID = networkID;
        this.list = list;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.func_150787_b(this.networkID);
        buffer.func_150787_b(this.list.size());
        this.list.forEach(pos -> FluxUtils.writeGlobalPos(buffer, pos));
    }

    @Override
    public void handle(@Nonnull PacketBuffer buffer, @Nonnull NetworkEvent.Context context) {
        int networkID = buffer.func_150792_a();
        IFluxNetwork network = FluxNetworkData.getNetwork(networkID);
        if (!network.isValid()) {
            return;
        }
        int size = buffer.func_150792_a();
        ArrayList<CompoundNBT> tags = new ArrayList<CompoundNBT>();
        for (int i = 0; i < size; ++i) {
            GlobalPos pos = FluxUtils.readGlobalPos(buffer);
            network.getConnectionByPos(pos).ifPresent(c -> {
                CompoundNBT tag = new CompoundNBT();
                c.writeCustomNBT(tag, 20);
                tags.add(tag);
            });
        }
        if (!tags.isEmpty()) {
            NetworkHandler.INSTANCE.reply(new SConnectionUpdateMessage(networkID, tags), context);
        }
    }
}

