/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.misc.IMessage;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.network.SFeedbackMessage;
import sonar.fluxnetworks.common.storage.FluxNetworkData;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public class CSelectNetworkMessage
implements IMessage {
    private BlockPos pos;
    private int networkID;
    private String password;

    public CSelectNetworkMessage() {
    }

    public CSelectNetworkMessage(BlockPos pos, int networkID, String password) {
        this.pos = pos;
        this.networkID = networkID;
        this.password = password;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_150787_b(this.networkID);
        buffer.func_211400_a(this.password, 256);
    }

    @Override
    public void handle(@Nonnull PacketBuffer buffer, @Nonnull NetworkEvent.Context context) {
        PlayerEntity player = NetworkHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        TileEntity tile = player.field_70170_p.func_175625_s(buffer.func_179259_c());
        if (!(tile instanceof TileFluxDevice)) {
            return;
        }
        TileFluxDevice flux = (TileFluxDevice)tile;
        int networkID = buffer.func_150792_a();
        if (flux.getNetworkID() == networkID) {
            return;
        }
        IFluxNetwork network = FluxNetworkData.getNetwork(networkID);
        if (!network.isValid()) {
            return;
        }
        if (flux.getDeviceType().isController() && !network.getConnections(FluxLogicType.CONTROLLER).isEmpty()) {
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.HAS_CONTROLLER), context);
        } else {
            if (CSelectNetworkMessage.checkAccess(buffer, context, player, network)) {
                return;
            }
            flux.setConnectionOwner(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()));
            flux.connect(network);
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.SUCCESS), context);
        }
    }

    static boolean checkAccess(@Nonnull PacketBuffer buffer, @Nonnull NetworkEvent.Context context, PlayerEntity player, @Nonnull IFluxNetwork network) {
        if (!network.getPlayerAccess(player).canUse()) {
            if (network.getSecurity().getType() == SecurityType.PRIVATE) {
                NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.REJECT), context);
                return true;
            }
            String password = buffer.func_150789_c(256);
            if (password.isEmpty()) {
                NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.PASSWORD_REQUIRE), context);
                return true;
            }
            if (!password.equals(network.getSecurity().getPassword())) {
                NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.REJECT), context);
                return true;
            }
        }
        return false;
    }
}

