/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.misc.IMessage;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.network.SFeedbackMessage;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public class FluxTileMessage
implements IMessage {
    private TileFluxDevice tile;
    private byte id;

    public FluxTileMessage() {
    }

    public FluxTileMessage(@Nonnull TileFluxDevice tile, byte id) {
        this.tile = tile;
        this.id = id;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.func_179255_a(this.tile.func_174877_v());
        buffer.writeByte((int)this.id);
        this.tile.writePacket(buffer, this.id);
    }

    @Override
    public void handle(@Nonnull PacketBuffer buffer, @Nonnull NetworkEvent.Context context) {
        PlayerEntity player = NetworkHandler.getPlayer(context);
        if (player == null) {
            if (context.getDirection().getOriginationSide().isServer()) {
                buffer.release();
            }
            return;
        }
        BlockPos pos = buffer.func_179259_c();
        TileEntity tile = player.field_70170_p.func_175625_s(pos);
        if (!(tile instanceof TileFluxDevice)) {
            if (player.field_70170_p.field_72995_K) {
                buffer.release();
            }
            return;
        }
        TileFluxDevice flux = (TileFluxDevice)tile;
        if (!player.field_70170_p.field_72995_K && !flux.canPlayerAccess(player)) {
            return;
        }
        byte type = buffer.readByte();
        flux.readPacket(buffer, type);
        if (type == 6 && !FluxConfig.enableChunkLoading) {
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.BANNED_LOADING), context);
        }
        if (player.field_70170_p.field_72995_K) {
            buffer.release();
        }
    }
}

