/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import sonar.fluxnetworks.common.block.FluxConnectorBlock;
import sonar.fluxnetworks.common.misc.EnergyUtils;
import sonar.fluxnetworks.common.tileentity.energy.TileDefaultEnergy;

public abstract class TileFluxConnector
extends TileDefaultEnergy {
    public TileFluxConnector(TileEntityType<? extends TileFluxConnector> tileEntityTypeIn, String customName, long limit) {
        super((TileEntityType<? extends TileDefaultEnergy>)tileEntityTypeIn, customName, limit);
    }

    @Override
    public void updateTransfers(Direction ... dirs) {
        super.updateTransfers(dirs);
        boolean sendUpdate = false;
        for (Direction facing : dirs) {
            boolean current;
            TileEntity neighbor = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            int mask = 1 << facing.func_176745_a();
            boolean before = (this.flags & mask) == mask;
            if (before == (current = EnergyUtils.canRenderConnection(neighbor, facing.func_176734_d()))) continue;
            this.flags ^= mask;
            sendUpdate = true;
        }
        if (sendUpdate) {
            this.sendFullUpdatePacket();
        }
    }

    @Override
    public void sendFullUpdatePacket() {
        if (!this.field_145850_b.field_72995_K) {
            BlockState state = this.func_195044_w();
            for (Direction dir : Direction.values()) {
                state = (BlockState)state.func_206870_a((Property)FluxConnectorBlock.SIDES_CONNECTED[dir.func_176745_a()], (Comparable)Boolean.valueOf((this.flags & 1 << dir.func_176745_a()) != 0));
            }
            this.field_145850_b.func_180501_a(this.field_174879_c, state, 1);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), state, -1);
        }
    }
}

