/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.tileentity.energy;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import sonar.fluxnetworks.api.misc.FluxCapabilities;
import sonar.fluxnetworks.common.misc.DefaultEnergyWrapper;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public abstract class TileDefaultEnergy
extends TileFluxDevice {
    private final Map<Direction, LazyOptional<DefaultEnergyWrapper>> wrappers = new EnumMap<Direction, LazyOptional<DefaultEnergyWrapper>>(Direction.class);

    public TileDefaultEnergy(TileEntityType<? extends TileDefaultEnergy> tileEntityTypeIn, String customName, long limit) {
        super(tileEntityTypeIn, customName, limit);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (side != null && (cap == CapabilityEnergy.ENERGY || cap == FluxCapabilities.FN_ENERGY_STORAGE)) {
            return this.wrappers.computeIfAbsent(side, s -> {
                DefaultEnergyWrapper wrapper = new DefaultEnergyWrapper(this, (Direction)s);
                return LazyOptional.of(() -> wrapper);
            }).cast();
        }
        return super.getCapability(cap, side);
    }
}

