/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.anvil.TileAnvilAuto;
import com.lothrazar.cyclic.block.beaconpotion.TilePotion;
import com.lothrazar.cyclic.block.breaker.TileBreaker;
import com.lothrazar.cyclic.block.collectfluid.TileFluidCollect;
import com.lothrazar.cyclic.block.crafter.TileCrafter;
import com.lothrazar.cyclic.block.disenchant.TileDisenchant;
import com.lothrazar.cyclic.block.dropper.TileDropper;
import com.lothrazar.cyclic.block.eye.TileEye;
import com.lothrazar.cyclic.block.eyetp.TileEyeTp;
import com.lothrazar.cyclic.block.forester.TileForester;
import com.lothrazar.cyclic.block.harvester.TileHarvester;
import com.lothrazar.cyclic.block.melter.TileMelter;
import com.lothrazar.cyclic.block.miner.TileMiner;
import com.lothrazar.cyclic.block.peatfarm.TilePeatFarm;
import com.lothrazar.cyclic.block.placer.TilePlacer;
import com.lothrazar.cyclic.block.shapebuilder.TileStructure;
import com.lothrazar.cyclic.block.solidifier.TileSolidifier;
import com.lothrazar.cyclic.block.uncrafter.TileUncraft;
import com.lothrazar.cyclic.block.user.TileUser;
import com.lothrazar.cyclic.enchant.EnchantAutoSmelt;
import com.lothrazar.cyclic.enchant.EnchantBeekeeper;
import com.lothrazar.cyclic.enchant.EnchantBeheading;
import com.lothrazar.cyclic.enchant.EnchantCurse;
import com.lothrazar.cyclic.enchant.EnchantDisarm;
import com.lothrazar.cyclic.enchant.EnchantExcavation;
import com.lothrazar.cyclic.enchant.EnchantGrowth;
import com.lothrazar.cyclic.enchant.EnchantLaunch;
import com.lothrazar.cyclic.enchant.EnchantLifeLeech;
import com.lothrazar.cyclic.enchant.EnchantMagnet;
import com.lothrazar.cyclic.enchant.EnchantMultishot;
import com.lothrazar.cyclic.enchant.EnchantPearl;
import com.lothrazar.cyclic.enchant.EnchantQuickdraw;
import com.lothrazar.cyclic.enchant.EnchantReach;
import com.lothrazar.cyclic.enchant.EnchantStep;
import com.lothrazar.cyclic.enchant.EnchantTraveller;
import com.lothrazar.cyclic.enchant.EnchantVenom;
import com.lothrazar.cyclic.enchant.EnchantXp;
import com.lothrazar.cyclic.item.TeleporterWandItem;
import com.lothrazar.cyclic.item.transporter.TileTransporterEmptyItem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigRegistry {
    private static final ForgeConfigSpec.Builder CFG = new ForgeConfigSpec.Builder();
    private static final List<String> BEHEADING = new ArrayList<String>();
    private static final List<String> UNCRAFT = new ArrayList<String>();
    private static final List<String> TRANSPORTBAG = new ArrayList<String>();
    private static final String WALL = "####################################################################################";
    private static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.IntValue PEATERICHPOWER;
    public static ForgeConfigSpec.IntValue PEATPOWER;
    public static ForgeConfigSpec.DoubleValue PEATCHANCE;
    public static ForgeConfigSpec.BooleanValue COMMANDNBT;
    public static ForgeConfigSpec.BooleanValue COMMANDGETHOME;
    public static ForgeConfigSpec.BooleanValue COMMANDHEALTH;
    public static ForgeConfigSpec.BooleanValue COMMANDHOME;
    public static ForgeConfigSpec.BooleanValue COMMANDHUNGER;
    public static ForgeConfigSpec.BooleanValue COMMANDPINGNETHER;
    public static ForgeConfigSpec.BooleanValue COMMANDWORLDSPAWN;
    public static ForgeConfigSpec.BooleanValue COMMANDGETHELP;
    public static ForgeConfigSpec.BooleanValue LOGINFO;
    public static ForgeConfigSpec.IntValue HEARTXPMINUS;
    private static ForgeConfigSpec.ConfigValue<List<String>> BEHEADING_SKINS;

    private static void buildDefaults() {
        BEHEADING.add("minecraft:blaze:MHF_Blaze");
        BEHEADING.add("minecraft:cat:MHF_Ocelot");
        BEHEADING.add("minecraft:cave_spider:MHF_CaveSpider");
        BEHEADING.add("minecraft:chicken:MHF_Chicken");
        BEHEADING.add("minecraft:cow:MHF_Cow");
        BEHEADING.add("minecraft:enderman:MHF_Enderman");
        BEHEADING.add("minecraft:ghast:MHF_Ghast");
        BEHEADING.add("minecraft:iron_golem:MHF_Golem");
        BEHEADING.add("minecraft:magma_cube:MHF_LavaSlime");
        BEHEADING.add("minecraft:mooshroom:MHF_MushroomCow");
        BEHEADING.add("minecraft:ocelot:MHF_Ocelot");
        BEHEADING.add("minecraft:pig:MHF_Pig");
        BEHEADING.add("minecraft:zombie_pigman:MHF_PigZombie");
        BEHEADING.add("minecraft:sheep:MHF_Sheep");
        BEHEADING.add("minecraft:slime:MHF_Slime");
        BEHEADING.add("minecraft:spider:MHF_Spider");
        BEHEADING.add("minecraft:squid:MHF_Squid");
        BEHEADING.add("minecraft:villager:MHF_Villager");
        BEHEADING.add("minecraft:witch:MHF_Witch");
        BEHEADING.add("minecraft:wolf:MHF_Wolf");
        BEHEADING.add("minecraft:guardian:MHF_Guardian");
        BEHEADING.add("minecraft:elder_guardian:MHF_Guardian");
        BEHEADING.add("minecraft:snow_golem:MHF_SnowGolem");
        BEHEADING.add("minecraft:silverfish:MHF_Silverfish");
        BEHEADING.add("minecraft:endermite:MHF_Endermite");
        UNCRAFT.add("minecraft:elytra");
        UNCRAFT.add("minecraft:beacon");
        UNCRAFT.add("minecraft:magma");
        UNCRAFT.add("minecraft:tipped_arrow");
        UNCRAFT.add("minecraft:cobweb");
        UNCRAFT.add("minecraft:*_dye");
        UNCRAFT.add("minecraft:stick");
        UNCRAFT.add("minecraft:netherite_ingot");
        UNCRAFT.add("cyclic:gem_*");
        UNCRAFT.add("forge:bucketfilled");
        UNCRAFT.add("progressiveautomation:*");
        UNCRAFT.add("spectrite:spectrite_arrow");
        UNCRAFT.add("spectrite:spectrite_arrow_special");
        UNCRAFT.add("techreborn:uumatter");
        UNCRAFT.add("projecte:*");
        TRANSPORTBAG.add("minecraft:spawner");
        TRANSPORTBAG.add("parabox:parabox");
        TRANSPORTBAG.add("extracells:fluidcrafter");
        TRANSPORTBAG.add("extracells:ecbaseblock");
        TRANSPORTBAG.add("extracells:fluidfiller");
    }

    private static void initConfig() {
        CFG.comment(new String[]{WALL, "Features with configurable properties are split into categories", WALL}).push("cyclic");
        CFG.comment(new String[]{WALL, " Enchantment related configs", WALL}).push("enchantment");
        EnchantAutoSmelt.CFG = CFG.comment("Set false to disable enchantment").define("auto_smelt", true);
        EnchantBeekeeper.CFG = CFG.comment("Set false to disable enchantment").define("beekeeper", true);
        EnchantBeheading.CFG = CFG.comment("Set false to disable enchantment").define("beheading", true);
        EnchantCurse.CFG = CFG.comment("Set false to disable enchantment").define("curse", true);
        EnchantDisarm.CFG = CFG.comment("Set false to disable enchantment").define("disarm", true);
        EnchantExcavation.CFG = CFG.comment("Set false to disable enchantment").define("excavate", true);
        EnchantGrowth.CFG = CFG.comment("Set false to disable enchantment").define("growth", true);
        EnchantLaunch.CFG = CFG.comment("Set false to disable enchantment").define("launch", true);
        EnchantLifeLeech.CFG = CFG.comment("Set false to disable enchantment").define("life_leech", true);
        EnchantMagnet.CFG = CFG.comment("Set false to disable enchantment").define("magnet", true);
        EnchantMultishot.CFG = CFG.comment("Set false to disable enchantment").define("multishot", true);
        EnchantPearl.CFG = CFG.comment("Set false to disable enchantment").define("ender", true);
        EnchantQuickdraw.CFG = CFG.comment("Set false to disable enchantment").define("quickshot", true);
        EnchantReach.CFG = CFG.comment("Set false to disable enchantment").define("reach", true);
        EnchantStep.CFG = CFG.comment("Set false to disable enchantment").define("step", true);
        EnchantTraveller.CFG = CFG.comment("Set false to disable enchantment").define("traveler", true);
        EnchantVenom.CFG = CFG.comment("Set false to disable enchantment").define("venom", true);
        EnchantXp.CFG = CFG.comment("Set false to disable enchantment").define("experience_boost", true);
        BEHEADING_SKINS = CFG.comment("Beheading enchant add player skin head drop, add any mob id and any skin").define("beheadingEntityMHF", BEHEADING);
        CFG.pop();
        CFG.comment(new String[]{WALL, " Edit the permissions of all commands added by the mod.  false means anyone can use, true means only OP players can use  ", WALL}).push("command");
        COMMANDGETHOME = CFG.comment("True means only players with OP can use this /cyclic command").define("gethome", false);
        COMMANDGETHELP = CFG.comment("True means only players with OP can use this /cyclic command").define("help", false);
        COMMANDHEALTH = CFG.comment("True means only players with OP can use this /cyclic command").define("health", true);
        COMMANDHOME = CFG.comment("True means only players with OP can use this /cyclic command").define("home", true);
        COMMANDHUNGER = CFG.comment("True means only players with OP can use this /cyclic command").define("hunger", true);
        COMMANDNBT = CFG.comment("True means only players with OP can use this /cyclic command").define("nbtprint", false);
        COMMANDPINGNETHER = CFG.comment("True means only players with OP can use this /cyclic command").define("pingnether", false);
        COMMANDWORLDSPAWN = CFG.comment("True means only players with OP can use this /cyclic command").define("worldspawn", true);
        CFG.pop();
        CFG.comment(new String[]{WALL, " Logging related configs", WALL}).push("logging");
        LOGINFO = CFG.comment("Unblock info logs; very spammy; can be useful for testing certain issues").define("info", false);
        CFG.pop();
        CFG.comment(new String[]{WALL, " Energy related configs for machines and items", WALL}).push("energy");
        CFG.comment(new String[]{WALL, " Fuel gained by consuming items", WALL}).push("fuel");
        PEATPOWER = CFG.comment(" Power gained burning one of this").defineInRange("peat_fuel", 256, 1, 64000);
        PEATERICHPOWER = CFG.comment("Power gained burning one of this").defineInRange("peat_fuel_enriched", 1024, 1, 64000);
        CFG.pop();
        CFG.comment(new String[]{WALL, "Energy cost for various machines, either per use of an action or per tick (twenty ticks per second).", WALL}).push("cost");
        TileDisenchant.POWERCONF = CFG.comment("Power per use disenchanter").defineInRange("disenchanter", 1500, 0, 64000);
        TileUser.POWERCONF = CFG.comment("Power per use user").defineInRange("user", 50, 0, 64000);
        TileAnvilAuto.POWERCONF = CFG.comment("Power per repair anvil").defineInRange("anvil", 250, 0, 64000);
        TileMelter.POWERCONF = CFG.comment("Power per recipe melter").defineInRange("melter", 5000, 0, 64000);
        TileSolidifier.POWERCONF = CFG.comment("Power per recipe solidifier").defineInRange("solidifier", 5000, 0, 64000);
        TileDropper.POWERCONF = CFG.comment("Power per use dropper").defineInRange("dropper", 50, 0, 64000);
        TileForester.POWERCONF = CFG.comment("Power per use forester").defineInRange("forester", 50, 0, 64000);
        TileHarvester.POWERCONF = CFG.comment("Power per use harvester").defineInRange("harvester", 250, 0, 64000);
        TilePotion.POWERCONF = CFG.comment("Power per tick beacon").defineInRange("beacon", 10, 0, 64000);
        TileMiner.POWERCONF = CFG.comment("Power per use miner").defineInRange("miner", 10, 0, 64000);
        TileUncraft.POWERCONF = CFG.comment("Power per use uncraft").defineInRange("uncraft", 1000, 0, 64000);
        TileFluidCollect.POWERCONF = CFG.comment("Power per use collector_fluid").defineInRange("collector_fluid", 500, 0, 64000);
        TilePeatFarm.POWERCONF = CFG.comment("Power per use peat_farm").defineInRange("peat_farm", 500, 0, 64000);
        TileCrafter.POWERCONF = CFG.comment("Power per use crafter").defineInRange("crafter", 500, 0, 64000);
        TileStructure.POWERCONF = CFG.comment("Power per tick while in use").defineInRange("structure", 10, 0, 64000);
        TilePlacer.POWERCONF = CFG.comment("Power per tick while in use").defineInRange("placer", 0, 0, 64000);
        TileBreaker.POWERCONF = CFG.comment("Power per tick while in use").defineInRange("breaker", 0, 0, 64000);
        TilePotion.POWERCONF = CFG.comment("Power per tick while in use").defineInRange("beacon", 0, 0, 64000);
        CFG.pop();
        CFG.pop();
        CFG.comment(new String[]{WALL, " Item specific configs", WALL}).push("items");
        CFG.comment("Wand settings").push("teleport_wand");
        TeleporterWandItem.RANGE = CFG.comment("Maximum distance to activate").defineInRange("range", 128, 16, 256);
        CFG.pop();
        CFG.comment("Sack of Holding settings").push("tile_transporter");
        TileTransporterEmptyItem.IGNORELIST = CFG.comment("Block these from being picked up").define("disable_pickup", TRANSPORTBAG);
        CFG.pop();
        CFG.comment("Peat blocks").push("peat");
        PEATCHANCE = CFG.comment("Chance that Peat Bog converts to Peat when wet (is multiplied by the number of surrounding water blocks)").defineInRange("conversionChance", (double)0.08f, (double)0.001f, 1.0);
        CFG.pop();
        CFG.comment("Heart items").push("heart");
        HEARTXPMINUS = CFG.comment("Experience given when eating a poisoned heart").defineInRange("experience", 500, 0, 99999);
        CFG.pop();
        CFG.pop();
        CFG.comment(new String[]{WALL, " Block specific configs", WALL}).push("blocks");
        CFG.comment("Ender Anchor settings").push("eye_teleport");
        TileEyeTp.RANGE = CFG.comment("Maximum distance to activate").defineInRange("range", 32, 2, 256);
        TileEyeTp.HUNGER = CFG.comment("Hunger cost on teleport").defineInRange("hunger", 1, 0, 20);
        TileEyeTp.EXP = CFG.comment("Exp cost on teleport").defineInRange("exp", 0, 0, 500);
        TileEyeTp.FREQUENCY = CFG.comment("Tick delay between checks, faster checks can consume server resources (1 means check every tick; 20 means only check once per second)").defineInRange("frequency", 5, 1, 20);
        CFG.pop();
        CFG.comment("Ender Trigger settings").push("eye_redstone");
        TileEye.RANGE = CFG.comment("Maximum distance to activate").defineInRange("range", 32, 2, 256);
        TileEye.FREQUENCY = CFG.comment("Tick delay between checks, faster checks can consume server resources (1 means check every tick; 20 means only check once per second)").defineInRange("frequency", 5, 1, 20);
        CFG.pop();
        CFG.comment("Uncrafter settings").push("uncrafter");
        TileUncraft.IGNORE_NBT = CFG.comment("When searching for a recipe, does it ignore all NBT values (such as enchantments, RepairCost, Damage, etc).  For example, if false it will not uncraft damaged or enchanted items").define("nbt_ignored", true);
        TileUncraft.IGNORELIST = CFG.comment("Block these from being un-crafted").define("ignore_list", UNCRAFT);
        TileUncraft.TIMER = CFG.comment("Ticks used for each uncraft").defineInRange("ticks", 60, 1, 9999);
        CFG.pop();
        CFG.pop();
        CFG.pop();
        COMMON_CONFIG = CFG.build();
    }

    public static void setup(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    public static Map<String, String> getMappedBeheading() {
        HashMap<String, String> mappedBeheading = new HashMap<String, String>();
        for (String s : (List)BEHEADING_SKINS.get()) {
            try {
                String[] stuff = s.split(":");
                String entity = stuff[0] + ":" + stuff[1];
                String skin = stuff[2];
                mappedBeheading.put(entity, skin);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Beheading Enchantment: Invalid config entry " + s);
            }
        }
        return mappedBeheading;
    }

    static {
        ConfigRegistry.buildDefaults();
        ConfigRegistry.initConfig();
    }
}

